<?php
namespace App\Http\Controllers;
use App\Models\Indicateur;
use App\Models\Extrant;
use App\Models\Etape;
use App\Models\Activite;
use App\Models\Evaluation;
use Illuminate\Http\Request;

class IndicateursController extends Controller
{
    public function index()
    {
        $extrants = Extrant::with('activite.evaluations.etape')
            ->get()
            ->map(function($extrant) {
                $activites = $extrant->activite ? [$extrant->activite] : [];
                $tauxTotal = 0;
                $count = 0;

                foreach($activites as $activite){
                    foreach($activite->evaluations as $evaluation){
                        if($evaluation->etape){
                            $tauxTotal += $evaluation->etape->niveauexec * 100; // en pourcentage
                            $count++;
                        }
                    }
                }

                $extrant->taux_execution = $count > 0 ? round($tauxTotal / $count, 2) : 0;
                return $extrant;
            });

        return view('indicateurs.index', compact('extrants'));
    }


    public function show($id)
    {
        $extrant = Extrant::with('activite.evaluations.etape')->findOrFail($id);

        $activite = $extrant->activite;
        $tauxTotal = 0;
        $count = 0;

        if($activite){
            foreach($activite->evaluations as $evaluation){
                if($evaluation->etape){
                    $tauxTotal += $evaluation->etape->niveauexec * 100;
                    $count++;
                }
            }
            $activite->taux_execution = $count > 0 ? round($tauxTotal / $count, 2) : 0;
        }

        return view('extrants.show', compact('extrant', 'activite'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'code' => 'required|string|max:20',
            'nom' => 'required|string|max:100',
            'valeur_cible' => 'required|numeric',
            'valeur_actuelle' => 'nullable|numeric',
            'description' => 'nullable|string',
        ]);
        return Indicateur::create($data);
    }

    public function update(Request $request, $id)
    {
        $i = Indicateur::findOrFail($id);
        $data = $request->validate([
            'code' => 'sometimes|string|max:20',
            'nom' => 'sometimes|string|max:100',
            'valeur_cible' => 'sometimes|numeric',
            'valeur_actuelle' => 'nullable|numeric',
            'description' => 'nullable|string',
        ]);
        $i->update($data);
        return $i;
    }

    public function destroy($id) {
	 Indicateur::findOrFail($id)->delete();
	 return response()->json(['message'=>'Indicateur supprimé']); }
}
