<?php

namespace App\Http\Controllers;

use App\Models\Rapport;
use Illuminate\Http\Request;

class RapportsController extends Controller
{
    public function index() { 
	return Rapport::all(); }
    public function show($id) {
	 return Rapport::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'titre' => 'required|string|max:100',
            'contenu' => 'required|string',
        ]);
        return Rapport::create($data);
    }

    public function update(Request $request, $id)
    {
        $r = Rapport::findOrFail($id);
        $data = $request->validate([
            'activite_id' => 'sometimes|integer',
            'titre' => 'sometimes|string|max:100',
            'contenu' => 'sometimes|string',
        ]);
        $r->update($data);
        return $r;
    }

    public function destroy($id) {
	 Rapport::findOrFail($id)->delete();
	 return response()->json(['message'=>'Rapport supprimé']); }
}
