<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GroupeActivite extends Model
{
    use HasFactory;

    protected $table = 'groupeactivites';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'description',
        'created_at',
        'updated_at',
		'csd_id',
    ];

    public $timestamps = true;

	// Relation avec Csd
    public function csd()
    {
        return $this->belongsTo(Csd::class, 'csd_id', 'id');
    }
	
	public function etapes()
    {
        return $this->hasMany(Etape::class, 'groupeactivite_id', 'id')->orderBy('ordre', 'asc');;
    }
	
	protected static function boot()
    {
        parent::boot();

        static::deleting(function ($modele) {
            if ($groupe->activites()->exists()) {
                throw new \Exception("Suppressison impossible : ce modèle possède encore des activités associées.");
            }
        });
    }
	
    public function activites()
    {
        return $this->hasMany(Activite::class, 'groupe_id', 'id');
    }
	
}
