<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrevisionActivite extends Model
{
    use HasFactory;

    protected $table = 'previsionactivites';
    protected $primaryKey = 'id';

    protected $fillable = [
        'activite_id',
        'ordreevaluation',
        'dateevaluation',
    ];

    public $timestamps = false;

    // Relation avec Activite
    public function activite()
    {
        return $this->belongsTo(Activite::class, 'activite_id', 'id');
    }

    // Relation avec Evaluations
    public function evaluations()
    {
        return $this->hasMany(Evaluation::class, 'previsionactivite_id', 'id');
    }
}
