<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Partenaire;
use App\Models\TypePartenaire;

class PartenaireSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // On s'assure qu'il existe des types de partenaires
        if (TypePartenaire::count() == 0) {
            $this->call(TypePartenaireSeeder::class);
        }

        $partenaires = [
            [
                'code' => 'P001',
                'nom' => 'Banque Mondiale',
                'desctiption' => 'Partenaire financier majeur des projets gouvernementaux.',
                'typepartenaire_id' => TypePartenaire::where('type', 'Bailleur de fonds')->first()->id ?? 1,
            ],
            [
                'code' => 'P002',
                'nom' => 'UNICEF',
                'desctiption' => 'Organisation internationale œuvrant pour la protection de l’enfance.',
                'typepartenaire_id' => TypePartenaire::where('type', 'Organisation internationale')->first()->id ?? 2,
            ],
            [
                'code' => 'P003',
                'nom' => 'SONABEL',
                'desctiption' => 'Entreprise publique du secteur de l’énergie.',
                'typepartenaire_id' => TypePartenaire::where('type', 'Institution publique')->first()->id ?? 3,
            ],
            [
                'code' => 'P004',
                'nom' => 'Plan International',
                'desctiption' => 'ONG engagée dans l’éducation et le bien-être des enfants.',
                'typepartenaire_id' => TypePartenaire::where('type', 'ONG / Association')->first()->id ?? 4,
            ],
            [
                'code' => 'P005',
                'nom' => 'CIMAF Burkina',
                'desctiption' => 'Entreprise privée soutenant des projets d’infrastructure.',
                'typepartenaire_id' => TypePartenaire::where('type', 'Entreprise privée')->first()->id ?? 5,
            ],
        ];

        foreach ($partenaires as $partenaire) {
            Partenaire::create($partenaire);
        }
    }
}
