@extends('layouts.app')

@section('title', 'Activité')

@section('content')
<div class="pagetitle">
  <h1>Ajout d'une Activité</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Accueil</a></li>
      <li class="breadcrumb-item">Activités</li>
      <li class="breadcrumb-item active">Ajout</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Ajouter une activité</h5>

          <form method="POST" action="{{ route('activites.store') }}">
            @csrf
			<div class="row g-3">
<div class="col-md-6">
                <label class="form-label"><b>CSD</b></label>
                <select id="csd_id" class="form-control" required>
                  <option value="">-- Choisir un CSD --</option>
                  @foreach($csds as $csd)
                    <option value="{{ $csd->id }}">{{ $csd->nom }}</option>
                  @endforeach
                </select>
              </div>
 <div class="col-md-6">
                <label class="form-label"><b>Groupe d'activité</b></label>
                <select name="groupe_id" id="groupe_id" class="form-control" required>
                  <option value="">-- Choisir un groupe --</option>
                </select>
              </div>

			</div>
			<div class="row g-3">
              <div class="col-md-3">
                <label class="form-label"><b>Code</b></label>
                  <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code"  value="{{ old('code') }}" required>
            @error('code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
              </div>

              <div class="col-md-9">
                <label class="form-label"><b>Nom</b></label>
                 <input type="text" class="form-control @error('nom') is-invalid @enderror" id="nom" name="nom"  value="{{ old('nom') }}" required>
        @error('nom')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date début</b></label>
             
                 <input type="date" class="form-control @error('datedebut') is-invalid @enderror" id="datedebut" name="datedebut"  value="{{ old('datedebut') }}" required>
        @error('datedebut')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date fin</b></label>
                 <input type="date" class="form-control @error('datefin') is-invalid @enderror" id="datefin" name="datefin"  value="{{ old('datefin') }}" required>
        @error('datefin')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Montant</b></label>
               
                 <input type="number" class="form-control @error('montant') is-invalid @enderror" id="montant" name="montant"  value="{{ old('montant') }}" required>
        @error('montant')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Structure responsable</b></label>
                <select name="structure_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($structures as $s)
                    <option value="{{ $s->id }}">{{ $s->nom }}</option>
                  @endforeach
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Action</b></label>
                <select name="action_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($actions as $a)
                    <option value="{{ $a->id }}" {{ $actionid == $a->id ? 'selected' : '' }}>
					{{ $a->nom }}</option>
                  @endforeach
                </select>
              </div>

              <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
                <button type="reset" class="btn btn-secondary">Réinitialiser</button>
              </div>

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const csdSelect = document.getElementById('csd_id');
    const groupeSelect = document.getElementById('groupe_id');

    csdSelect.addEventListener('change', function () {
        const csdId = this.value;
        groupeSelect.innerHTML = '<option value="">-- Chargement... --</option>';

        if (csdId) {
            fetch(`/activites/groupes/${csdId}`)
                .then(response => response.json())
                .then(data => {
                    groupeSelect.innerHTML = '<option value="">-- Choisir un groupe --</option>';
                    data.forEach(groupe => {
                        const option = document.createElement('option');
                        option.value = groupe.id;
                        option.textContent = groupe.nom;
                        groupeSelect.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Erreur:', error);
                    groupeSelect.innerHTML = '<option value="">-- Erreur de chargement --</option>';
                });
        } else {
            groupeSelect.innerHTML = '<option value="">-- Choisir un groupe --</option>';
        }
    });
});
</script>

@endsection
