@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
      <h1>Tableau de bord</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Tableau de bord</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
	  

      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">

           

        

          
 <div class="row">

    <!-- Structures en retard -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Structures ayant dépassé leur délai d’évaluation</h5>
          <table class="table table-striped">
            <thead>
              <tr><th>Structure</th><th>Année réf.</th><th>Dernière mise à jour</th></tr>
            </thead>
            <tbody>
              @foreach($structuresEnRetard as $s)
              <tr>
                <td>{{ $s->nom }}</td>
                <td>{{ $s->anneeref }}</td>
                <td>{{ \Carbon\Carbon::parse($s->updated_at)->format('d/m/Y') }}</td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Top 10 meilleurs taux -->
    <div class="col-lg-6">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Top 10 des meilleurs taux d’exécution</h5>
          <ul class="list-group">
            @foreach($topStructures as $t)
              <li class="list-group-item d-flex justify-content-between align-items-center">
                {{ $t->nom }}
                <span class="badge bg-success">{{ $t->taux }} %</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>

    <!-- Top 10 plus faibles taux -->
    <div class="col-lg-6">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Top 10 des taux les plus faibles</h5>
          <ul class="list-group">
            @foreach($lowStructures as $l)
              <li class="list-group-item d-flex justify-content-between align-items-center">
                {{ $l->nom }}
                <span class="badge bg-danger">{{ $l->taux }} %</span>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>

    <!-- Graphique -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Taux moyens par programme</h5>
          <canvas id="tauxChart"></canvas>
        </div>
      </div>
    </div>

  </div>
          

            <!-- Recent Sales -->
			
			
            
			
			
			

        

          </div>
        </div><!-- End Left side columns -->

    

      </div>
    </section>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('tauxChart');
new Chart(ctx, {
  type: 'line',
  data: {
    labels: {!! json_encode($tauxParProgramme->pluck('nom')) !!},
    datasets: [{
      label: 'Taux moyen (%)',
      data: {!! json_encode($tauxParProgramme->pluck('taux_moyen')) !!},
      borderWidth: 2,
      borderColor: 'rgba(54, 162, 235, 1)',
      fill: false,
      tension: 0.3
    }]
  },
  options: {
    scales: { y: { beginAtZero: true } }
  }
});
</script>
@endsection
