<?php

namespace App\Http\Controllers;

use App\Models\Evaluation;
use Illuminate\Http\Request;

class EvaluationsController extends Controller
{
    public function index() { 
	return Evaluation::all(); }
    public function show($id) { 
	return Evaluation::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'etape_id' => 'required|integer',
            'previsionactivite_id' => 'required|integer',
            'valide' => 'boolean',
            'commentaire' => 'nullable|string',
        ]);
        return Evaluation::create($data);
    }

    public function update(Request $request, $id)
    {
        $eval = Evaluation::findOrFail($id);
        $data = $request->validate([
            'activite_id' => 'sometimes|integer',
            'etape_id' => 'sometimes|integer',
            'previsionactivite_id' => 'sometimes|integer',
            'valide' => 'boolean',
            'commentaire' => 'nullable|string',
        ]);
        $eval->update($data);
        return $eval;
    }

    public function destroy($id) {
	 Evaluation::findOrFail($id)->delete(); 
	return response()->json(['message'=>'Évaluation supprimée']); }
}
