<?php

namespace App\Http\Controllers;

use App\Models\ResponsableProgramme;
use Illuminate\Http\Request;

class ResponsableProgrammesController extends Controller
{
    public function index() { 
return ResponsableProgramme::all(); 
}

    public function show($id) {
 return ResponsableProgramme::findOrFail($id);
 }

    public function store(Request $request)
    {
        $data = $request->validate([
            'programme_id' => 'required|integer',
            'user_id' => 'required|integer',
            'datedebut' => 'required|date',
            'datefin' => 'nullable|date',
        ]);
        return ResponsableProgramme::create($data);
    }

    public function update(Request $request, $id)
    {
        $resp = ResponsableProgramme::findOrFail($id);
        $data = $request->validate([
            'programme_id' => 'sometimes|integer',
            'user_id' => 'sometimes|integer',
            'datedebut' => 'sometimes|date',
            'datefin' => 'nullable|date',
        ]);
        $resp->update($data);
        return $resp;
    }

    public function destroy($id) { 
ResponsableProgramme::findOrFail($id)->delete(); 
return response()->json(['message'=>'Responsable supprimé']); 
}
}
