<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StructureActivite;
use App\Models\Activite;

class StructureActivitesController extends Controller
{
    /**
     * Afficher toutes les structures partenaires.
     */
    public function index($activiteid)
    {
        return StructureActivite::all(); 
    }

    /**
     * Attacher une structure partenaire à une activité.
     *
     * @param int $structureid
     * @param int $activiteid
     * @param bool $activestate
     */
    public function attach($structureid, $activiteid, $activitestate)
    {
        // L'activité doit être active et ouverte pour ajouter
        if (!$activitestate) {
            return redirect()->route('activites.show', $activiteid)
                             ->with('error', 'L\'activité doit être activée et ouverte aux modifications.');
        }

        $data = new StructureActivite();
        $data->structure_id = $structureid;
        $data->activite_id = $activiteid;
		$data->datedebut = now();
        $data->is_active = true;

        if ($data->save()) {
            return redirect()->route('activites.show', $activiteid)
                             ->with('success', 'Structure partenaire ajoutée avec succès.');
        } else {
            return redirect()->route('activites.show', $activiteid)
                             ->with('error', 'Échec de l\'ajout de la structure partenaire.');
        }
    }

    /**
     * Détacher une structure partenaire d'une activité.
     *
     * @param int $id
     */
    public function detach($id)
    {
        $data = StructureActivite::findOrFail($id);
        $data->is_active = false;
		$data->datefin = now();
		
        if ($data->save()) {
            return redirect()->route('activites.show', $data->activite_id)
                             ->with('success', 'Structure partenaire détachée avec succès.');
        } else {
            return redirect()->route('activites.show', $data->activite_id)
                             ->with('error', 'Échec du détachement de la structure partenaire.');
        }
    }
}
