<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Csd extends Model
{
    use HasFactory;

    protected $table = 'csds';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'description',
        'created_at',
        'updated_at',
    ];

    public $timestamps = true;

    // Relation avec ModeleActivites
    public function modeleActivites()
    {
        return $this->hasMany(ModeleActivite::class, 'csd_id', 'id');
    }
}
