<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Structure extends Model
{
    use HasFactory;

    protected $table = 'structures';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'description',
        'ministere_id',
        'created_at',
        'updated_at',
    ];

    public $timestamps = true;

    // Relation avec Ministere
    public function ministere()
    {
        return $this->belongsTo(Ministere::class, 'ministere_id', 'id');
    }

    // Relation avec Pointfocals
    public function pointfocals()
    {
        return $this->hasMany(Pointfocal::class, 'structure_id', 'id');
    }

    // Relation avec Activites
    public function activites()
    {
        return $this->hasMany(Activite::class, 'structure_id', 'id');
    }
	
	// Table pivot
    public function actions()
    {
        return $this->belongsToMany(Action::class, 'structure_action', 'structure_id', 'action_id');
    }
	
	public function activitespartenaires()
    {
        return $this->belongsToMany(Activite::class, 'structure_activite', 'structure_id', 'activite_id');
    }
}
