<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Csd;

class CsdSeeder extends Seeder
{
    public function run(): void
    {
        $csds = [
            [
                'code' => 'CSD001',
                'nom' => 'CSD Nord',
                'description' => 'Centre de Suivi et de Développement du Nord.',
            ],
            [
                'code' => 'CSD002',
                'nom' => 'CSD Centre',
                'description' => 'Couvre la région du Centre et appuie les projets de développement urbain.',
            ],
            [
                'code' => 'CSD003',
                'nom' => 'CSD Ouest',
                'description' => 'Centre axé sur la coordination des programmes ruraux à l’Ouest.',
            ],
            [
                'code' => 'CSD004',
                'nom' => 'CSD Est',
                'description' => 'Appui à la mise en œuvre des projets dans la région de l’Est.',
            ],
        ];

        foreach ($csds as $csd) {
            Csd::create($csd);
        }
    }
}
