@extends('layouts.app')

@section('title', 'Resultat')

@section('content')
<div class="pagetitle">
  <h1>Ajout d'un Résultat</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Accueil</a></li>
      <li class="breadcrumb-item">Résultats</li>
      <li class="breadcrumb-item active">Ajout</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Ajouter un résultat à l'action : <strong>{{ $action->nom }}</strong></h5>

          <form method="POST" action="{{ route('resultats.store') }}">
            @csrf
			<input type="hidden" name="action_id" value="{{ old('action_id', $action->id) }}">
            <div class="row g-3">
              <div class="col-md-3">
                <label class="form-label">Libellé : </label>
                <input type="text" name="nom" class="form-control" value="{{ old('nom') }}" required>
              </div>

              <div class="col-md-9">
                <label class="form-label">Description</label>
                <input type="text" name="description" class="form-control" value="{{ old('description') }}" required>
              </div>
              <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
                <button type="reset" class="btn btn-secondary">Réinitialiser</button>
              </div>
            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
@endsection
