
<?php $__env->startSection('title', 'Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Détails Activité</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('actions.show', $activite->action_id)); ?>">Détails Action</a></li>
            <li class="breadcrumb-item active">Détails Activité</li>
        </ol>
    </nav>
</div><!-- End Page Title -->

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Détails de l'activité</h5>

                    <?php if(Session::has('status')): ?>
                        <div class="col-md-3" style="margin-left:15%">
                            <div class="card card-success shadow-sm">
                                <div class="card-header">
                                    <h3 class="card-title">Correct</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <?php echo e(Session::get('status')); ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="card-body">
                        <h2>Détails : <strong><?php echo e($activite->nom); ?></strong></h2>
                        <hr>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="callout callout-primary">
                                    <h5><b><u>Informations générales</u></b></h5>
                                    <ul class="list-group list-group-unbordered mb-3">
                                        <li class="list-group-item">
                                            <b>Code :</b> <span class="float-right"><?php echo e($activite->code); ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Nom :</b> <span class="float-right"><?php echo e($activite->nom); ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Description :</b> <span class="float-right"><?php echo e($activite->description ?? '-'); ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Montant :</b> <span class="float-right"><?php echo e($activite->montant ?? '-'); ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Date Début :</b> <span class="float-right"><?php echo e($activite->datedebut); ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Date Fin :</b> <span class="float-right"><?php echo e($activite->datefin ?? 'En cours'); ?></span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Actif :</b> 
                                            <?php if((Auth::user()->usergroup_id == 4) || (!$activite->valide)): ?>
                                                <button class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
                                                    <?php echo e($activite->actif ? 'OUI' : 'NON'); ?>

                                                </button>
                                            <?php else: ?>
												 <a href="<?php echo e(route('activites.actif', $activite->id)); ?>" 
													class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($activite->actif ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Ouvert :</b> 
                                            <?php if((Auth::user()->usergroup_id == 4) || (!$activite->valide)): ?>
                                                <button class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
                                                    <?php echo e($activite->ouvert ? 'OUI' : 'NON'); ?>

                                                </button>
                                            <?php else: ?>
												<a href="<?php echo e(route('activites.ouvert', $activite->id)); ?>" 
													class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($activite->ouvert ? 'OUI' : 'NON'); ?>

												</a>
											<?php endif; ?>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <hr>

                        
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Informations liées</u></b></h5>
                                <ul class="list-group list-group-unbordered mb-3">
                                    <li class="list-group-item">
                                        <b>Groupe d'activité :</b> 
                                        <span class="float-right"><?php echo e($activite->groupeactivite->nom ?? '-'); ?></span>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Action :</b> 
                                        <span class="float-right"><?php echo e($activite->action->nom ?? '-'); ?></span>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Structure responsable :</b> 
                                        <span class="float-right"><?php echo e($activite->structureresponsable->nom ?? '-'); ?></span>
                                    </li>
                                </ul>
                            </div>
                        </div>

			<div class="row">
                            <div class="col-md-10">
                                <div class="callout callout-primary">
                                    <h5><b><u>ETAT DE VALIDATION :</u></b></h5>
                                    <ul class="list-group list-group-unbordered mb-3">
                                        <li class="list-group-item">
										<b>ETAT :</b>
											<?php if(Auth::user()->usergroup_id == 4): ?>
												<button class="btn btn-sm <?php echo e($activite->valide ? 'btn-success' : 'btn-secondary'); ?>" disabled>
                                                    <?php echo e($activite->valide ? 'VALIDE' : 'NON VALIDE'); ?>

                                                </button>
											<?php else: ?>
												<td><a href="<?php echo e(route('activites.valide', $activite->id)); ?>" 
													class="btn btn-sm <?php echo e($activite->valide ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($activite->valide ? 'VALIDE' : 'NON VALIDE'); ?>

												</a></td>
											<?php endif; ?>
										</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <hr>

                        
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Étapes</u></b></h5>
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>Ordre</th>
                                            <th>Nom</th>
                                            <th>Pondération</th>
                                            <th>Niveau exécution</th>
                                            <th>Source de vérification</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $activite->etapes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $etape): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($etape->ordre); ?></td>
                                                <td><?php echo e($etape->nom); ?></td>
                                                <td><?php echo e($etape->ponderation); ?></td>
                                                <td><?php echo e($etape->niveauexec); ?></td>
                                                <td><?php echo e($etape->sourceverif ?? '-'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <hr>

                        
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Évaluations</u></b></h5>
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>Étape</th>
                                            <th>Prévision (%)</th>
                                            <th>Réalisation (%)</th>
                                            <th>Validé</th>
                                            <th>Commentaire</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $activite->evaluations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($eval->etape->nom ?? '-'); ?></td>
                                                <td><?php echo e($eval->taux_prevision); ?></td>
                                                <td><?php echo e($eval->taux_realisation); ?></td>
                                                <td><?php echo e($eval->valide ? 'OUI' : 'NON'); ?></td>
                                                <td><?php echo e($eval->commentaire ?? '-'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <hr>

                        
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Structures partenaires</u></b></h5>
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>Structure</th>
                                            <th>Ministère</th>
                                            <th>Début</th>
                                            <th>Fin</th>
                                        </tr>
                                    </thead>
                                    <tbody>
										<?php
											$canAddStructure = ($activite->ouvert && $activite->actif) || (!$activite->valide);
										?>
										<?php if($canAddStructure): ?>
											<h6 class="card-title">
												<a href="<?php echo e(route('structures.selecforactivite', ['activiteid' => $activite->id, 'activitestate' => $canAddStructure])); ?>" 
												   class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une structure
												</a>
											</h6>
										<?php endif; ?>
										<?php if(!is_null($activite->structurespartenaires)): ?>
											<?php $__currentLoopData = $activite->structurespartenaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td><?php echo e($structure->nom); ?> (<?php echo e($structure->code); ?>)</td>
													<td><?php echo e($structure->ministere->nom ?? '-'); ?></td>
													<td><?php echo e($structure->pivot->datedebut ?? 'En cours'); ?></td>
													<td><?php echo e($structure->pivot->datefin ?? 'En cours'); ?></td>
													<td> <a href="<?php echo e(route('structureactivites.detach', $structure->pivot->id)); ?>" class="btn btn-info">X</a>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
						<div class="callout callout-primary">
								<h5><b><u><b>Historique des anciens intervenants</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Structure</th>
											<th>Ministère</th>
											<th>Du : </th>
											<th>Au : </th>
										</tr>
									</thead>
									<tbody>
										<?php if(!is_null($activite->structurearchives)): ?>
											<?php $__currentLoopData = $activite->structurearchives; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structureold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e($structureold->nom); ?> (<?php echo e($structureold->code); ?>)</td>
												<td><?php echo e($structureold->ministere->nom); ?> (<?php echo e($structureold->ministere->code); ?>)</td>
												<td><?php echo e($structureold->pivot->datedebut); ?></td>
												<td><?php echo e($structureold->pivot->datefin); ?></td>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
                    </div> <!-- End card-body -->
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/show.blade.php ENDPATH**/ ?>