<?php

namespace App\Http\Controllers;

use App\Models\Activite;
use App\Models\Csd;
use App\Models\GroupeActivite;
use App\Models\Action;
use App\Models\Structure;
use App\Models\PrevisionActivite;
use Illuminate\Http\Request;
use Carbon\Carbon;

class ActivitesController extends Controller
{
    public function index()
    {
        $activites = Activite::with(['action', 'structureresponsable'])->orderBy('code')->get();
        return view('activites.index', compact('activites'));
    }

    public function create($actionid=null)
    {
		if(isset($actionid)){
			$action = Action::select('ouvert', 'actif')->findOrFail($actionid);
			if(!$action->ouvert){
				return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée');
			}
			if(!$action->actif){
				return redirect()->back()->with('error', 'Impossible, demandez l\'activation de l\'action');
			}
		}
		$structures = Structure::where('is_active', true)->get();
		//$csds = Csd::orderBy('code')->get();
		//$groupes = GroupeActivite::where('is_active', true)->orderBy('csd_id')->orderBy('code')->get();
		$csds = Csd::whereHas('groupeactivites', function ($query) {
    $query->where('is_active', true)
          ->whereHas('etapes');
})
->orderBy('nom')
->get();
		$groupes = GroupeActivite::where('is_active', true)
			->whereHas('etapes') // seulement les groupes ayant au moins une étape liée
			->orderBy('csd_id')
			->orderBy('code')
			->get();
		$actions = Action::where('actif',true)->where('ouvert',true)->orderBy('code')->get();
		
        return view('activites.create', compact('actions', 'structures', 'groupes', 'actionid', 'csds'));
    }

    public function store(Request $request)
    {
	//dd($request); die();
        $request->validate([
			'groupe_id' => 'required|integer',
            'code' => 'required',
            'nom' => 'required',
            'datedebut' => 'required|date',
            'datefin' => 'required|date|after_or_equal:datedebut',
            'montant' => 'required|numeric',
            'structure_id' => 'required|integer',
            'action_id' => 'required|integer'
		]);
		
		//$action = Action::select('ouvert', 'actif')->findOrFail($request->action_id);
		//if($action->ouvert && $action->actif){
			//Activite::create($request->all());
			//return redirect()->route('actions.show', $request->action_id)->with('success', 'Activité ajoutée avec succès.');
		//}
        //return redirect()->route('activites.index')->with('success', 'Activité créée avec succès.');
		//return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée');
		try {
            $action = Action::select('ouvert', 'actif')->findOrFail($request->action_id);

            if ($action->ouvert && $action->actif) {
                $data = new Activite($request->all());

                if ($data->save()) {
                    return redirect()->route('actions.show', $request->action_id)
                        ->with('success', 'Activité ajoutée avec succès.');
                } else {
                    return redirect()->back()->with('error', 'Échec de l’enregistrement de l’activité.');
                }
            }

            return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function show($id)
    {
	    //dd("En cours"); die();
		$activite = Activite::with(['action', 'structureresponsable', 'groupeactivite', 'structurespartenaires', 'evaluations', 'etapes', 'previsions'])->findOrFail($id);
        //dd($activite); die();
		// voir les prévisions non encore évaluées mais passées
		$evalwaitings = PrevisionActivite::doesntHave('evaluations')
			->where('activite_id', $id)
			->where('dateevaluation', '<=', Carbon::now()->toDateString())
			->get();
		
		return view('activites.show', compact('activite', 'evalwaitings'));
    }
	
	public function planning($id)
    {
	    //dd("En cours"); die();
		$activite = Activite::with(['action', 'structureresponsable', 'groupeactivite', 'previsions'])->findOrFail($id);
        //dd($activite); die();
		
		// if($activite->clos){
			// return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
		// }
		// if($activite->valide && (!$activite->ouvert || !$activite->actif)){
			// return redirect()->back()->with('error', 'Impossible. L\'activité doit être non validé ou bien actif et ouvert');
		// }
		
		$evalwaitings = PrevisionActivite::doesntHave('evaluations')
			->where('activite_id', $id)
			->where('dateevaluation', '<=', Carbon::now()->toDateString())
			->get();
		
		return view('activites.planning', compact('activite', 'evalwaitings'));
    }
	
	public function evaluate($id)
    {
	    //dd("En cours"); die();
		// Désactiver le cache navigateur
		header("Cache-Control: no-cache, must-revalidate, max-age=0");
		header("Pragma: no-cache");
		header("Expires: Fri, 01 Jan 1990 00:00:00 GMT");
		
		$activite = Activite::with(['action', 'structureresponsable', 'groupeactivite', 'evaluations'])->findOrFail($id);
        //dd($activite); die();
		//if($activite->clos){
		//	return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
		//}
		//if(!$activite->valide || !$activite->actif || $activite->ouvert){
		//	return redirect()->back()->with('error', 'Impossible. L\'activité doit être validée, active et pas en cours de révision');
		//}
		$evalwaitings = PrevisionActivite::doesntHave('evaluations')
			->where('activite_id', $id)
			->where('dateevaluation', '<=', Carbon::now()->toDateString())
			->get();
		
		return view('activites.evaluate', compact('activite', 'evalwaitings'));
    }

    public function edit($id)
    {
        $activite = Activite::findOrFail($id);
		
		 if($activite->valide && (!$activite->ouvert || !$activite->actif)){
		 	return redirect()->back()->with('error', 'Impossible. L\'activité doit être non validé ou bien actif et ouvert');
		 }
		if($activite->clos){
			return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
		}
        $actions = Action::all();
        $structures = Structure::where('is_active', true)->get();
		//$groupes = GroupeActivite::where('is_active', true)->orderBy('csd_id')->orderBy('code')->get();

		$groupes = GroupeActivite::where('is_active', true)
			->whereHas('etapes') // seulement les groupes ayant au moins une étape liée
			->orderBy('csd_id')
			->orderBy('code')
			->get();
	return view('activites.edit', compact('activite', 'actions', 'structures', 'groupes'));
    }

    public function update(Request $request, $id)
    {
        $activite = Activite::findOrFail($id);
		if($activite->clos){
			return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
		}
		
		$validated =$request->validate([
			'groupe_id' => 'required|integer',
            'code' => 'required',
            'nom' => 'required',
            'datedebut' => 'required|date',
            'datefin' => 'required|date|after_or_equal:datedebut',
            'montant' => 'required|numeric',
            'structure_id' => 'required|integer',
            'action_id' => 'required|integer'
        ]);
       // $activite->update($validated);

        //return redirect()->route('activites.index')->with('success', 'Activité mise à jour avec succès.');
        try {
            $activite = Activite::findOrFail($id);
	    $activite->fill($validated);
            if ($activite->save()) {
	        $activite->update([
       		'valide' => false,
        	'actif' => false,
        	'ouvert' => false,
	        ]);
                return redirect()->route('activites.index')->with('success', 'Activité mise à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour de l’activité.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function destroy($id)
    {	
        try {
            $activite = Activite::with('groupeactivite', 'structurespartenaires')->findOrFail($id);
			
			$cant_delete = $activite->previsions()->exists()
						|| $activite->evaluations()->exists()
						|| $activite->structurespartenaires()->exists();
			//dd($cant_delete); die();
			if($cant_delete) {
				return redirect()->back()->with('error', 'Impossible. Cette activité liée à des données (évaluations, prévisions, structures,...');
			}
			
			if($activite->clos || $activite->valide){
				return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée ou validée');
			}
            $actionid = $activite->action_id;

            if ($activite->delete()) {
                return redirect()->route('actions.show', $actionid)->with('success', 'Activité supprimée avec succès.');
            } else {
                return redirect()->route('actions.show', $actionid)->with('error', 'Échec de la suppression.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
	
	public function valide($id)
    {
        $activite = Activite::findOrFail($id);
		if($activite->clos){
			return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
		}
		$activite->valide = !$activite->valide;
		if (!$activite->valide) {
			$activite->actif = false;
            $activite->ouvert = false;
        }
		 if ($activite->save()) {
			return redirect()->back()->with('success', 'État mis à jour avec succès.');
		} else {
			return redirect()->back()->with('error', 'Échec de la mise à jour de l’état.');
		}
    }

    public function actif($id)
    {
		try {
            $activite = Activite::findOrFail($id);
			if($activite->clos){
				return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
			}
            $actionactif = Action::select('actif')->findOrFail($activite->action_id);
			
		if(!$activite->valide){
			return redirect()->back()->with('error', 'Impossible, validez d\'abord par le responsable désigné');
		}

            if ($actionactif->actif) {
                $activite->actif = !$activite->actif;
                if (!$activite->actif) {
                    $activite->ouvert = false;
                }

                if ($activite->save()) {
                    return redirect()->back()->with('success', 'État mis à jour avec succès.');
                } else {
                    return redirect()->back()->with('error', 'Échec de la mise à jour de l’état.');
                }
            }

            return redirect()->back()->with('error', 'Non effectué. Vérifiez que l\'activité est active.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    
    public function ouvert($id)
    {
        try {
            $activite = Activite::findOrFail($id);
			if($activite->clos){
				return redirect()->back()->with('error', 'Impossible. Cette activité est cloturée');
			}
		
            $actionouvert = Action::select('ouvert')->findOrFail($activite->action_id);

            if ($actionouvert->ouvert) {
                $newstate = !$activite->ouvert;

                if ($newstate && !$activite->actif) {
                    return redirect()->back()->with('error', 'Impossible, activez d\'abord l’activité.');
                }

                $activite->ouvert = $newstate;

                if ($activite->save()) {
                    return redirect()->back()->with('success', 'État d’ouverture modifié avec succès.');
                } else {
                    return redirect()->back()->with('error', 'Échec de la modification de l’état.');
                }
            }

            return redirect()->back()->with('error', 'Non effectué. Vérifiez que l\'activité est ouverte.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
	
	public function getGroupesParCsd($id)
    {
	$groupes = GroupeActivite::where('csd_id', $id)
		->where('is_active', true)
		->whereHas('etapes')       // seulement les groupes ayant des étapes
		->orderBy('code')
		->get(['id', 'nom']);

    return response()->json($groupes);
    } 
}
