<?php

namespace App\Http\Controllers;

use App\Models\Etape;
use App\Models\Activite;
use Illuminate\Http\Request;

class EtapesController extends Controller
{
    /* public function index($groupeactiviteid) {
		$etapes = Etape::where('groupeactivite_id', $groupeactiviteid)->get();
		return view('etapes.index', compact('etapes'));
	} */
    /* public function show($id) {
		return Etape::findOrFail($id); 
	} */
	
	public function create($groupeactiviteid)
    {
		$nbractivites = Activite::where('groupe_id', $groupeactiviteid)->where('valide', true)->count();
		
		if($nbractivites > 0){
			return redirect()->back()->with('success', 'Impossible, le modéle est lié à une activité validée');
		}
		
		$dernierOrdre = Etape::where('groupeactivite_id', $groupeactiviteid)->max('ordre');
		$dernierOrdre = $dernierOrdre ? $dernierOrdre + 1 : 1;
		
		$sommeExistante = Etape::where('groupeactivite_id', $groupeactiviteid)->sum('ponderation');

		//dd($dernierOrdre); die();
        return view('etapes.create', compact('groupeactiviteid', 'dernierOrdre', 'sommeExistante'));
    }

    public function store(Request $request)
    {
        /* $data = $request->validate([
            'groupeactivite_id' => 'required|integer',
            'ordre' => 'required|integer',
            'nom' => 'required|string|max:100',
            'ponderation' => 'required|numeric',
            'niveauexec' => 'required|numeric',
            'sourceverif' => 'nullable|string|max:100',
        ]); */
		$data = $request->validate([
			'groupeactivite_id' => 'required|integer',
            'ordre' => 'required|integer',
			'nom' => 'required|string|max:100',
			'ponderation' => 'required|numeric',
			'niveauexec' => 'required|numeric',
			'sourceverif' => 'nullable|string|max:100',
		]);
		
		
		$groupeactiviteid = $request->input('groupeactivite_id'); 
		
		if (!Etape::where('groupeactivite_id', $groupeactiviteid)->exists() && !$groupeactiviteid) {
			//return redirect()->back()->withErrors(['groupeactivite_id' => 'Valeur invalide']);
		}
		
		// Récupère l'ordre maximum pour ce groupeactivite_id et calcule l'ordre correct
		$dernierOrdre = Etape::where('groupeactivite_id', $groupeactiviteid)->max('ordre');
		$ordreCorrect = $dernierOrdre ? $dernierOrdre + 1 : 1;
		
		// Force les valeurs côté serveur, ignore celles envoyées par le client
		$data['ordre'] = $ordreCorrect;
		
		//$niveauexec = Etape::where('groupeactivite_id', $groupeactiviteid)->orderByDesc('ordre')->value('niveauexec');
		$niveauexec = Etape::where('groupeactivite_id', $groupeactiviteid)->sum('ponderation') ?? 0;
		$niveauexec =  (float)$niveauexec + (float) $data['ponderation'];
		
		//$data['niveauexec'] = $niveauexec;
		
		//dd($data); die();
		
		if (($data['niveauexec'] - $niveauexec  > 0.1) || $niveauexec > 100) {
			throw ValidationException::withMessages(['ponderation' => ['La somme des pondérations (existantes + nouvelle) dépasse 100.'],]);
        }
		
        Etape::create($data);
		
		return redirect()->route('groupeactivites.show', $request->groupeactivite_id)->with('success', 'Données ajoutées avec succès.');
    }
	
	public function edit($id)
    {
	    $etape = Etape::findOrFail($id);
	    $sommeExistante = $etape->niveauexec - $etape->ponderation;
		
		$nbractivites = Activite::where('groupe_id', $etape->groupeactivite_id)->where('valide', true)->count();
		if($nbractivites > 0){
			return redirect()->back()->with('success', 'Impossible, le modéle est lié à une activité validée');
		}
        
        return view('etapes.edit', compact('etape', 'sommeExistante'));
    }
	
    public function update(Request $request, $id)
    {
        $e = Etape::findOrFail($id);
	$groupeid = $request->groupeactivite_id;
		$ordre = $request->ordre;
        $data = $request->validate([
            'nom' => 'sometimes|string|max:100',
            'ponderation' => 'sometimes|numeric',
            'niveauexec' => 'sometimes|numeric',
            'sourceverif' => 'nullable|string|max:100',
        ]);
		
		//$niveauexec = Etape::where('groupeactivite_id', $modelid)->where('ordre', '<=', $ordre)->sum('ponderation') ?? 0;
		//$data['niveauexec'] = $niveauexec;
        $e->update($data);
		
		//Recalcul des niveauexec des étapes suivantes
		$etapesSuivantes = Etape::where('groupeactivite_id', $groupeid)->where('ordre', '>', $ordre)->orderBy('ordre', 'asc')->get();

		$niveauexecCourant = $data['niveauexec']; // valeur recalculée de l’étape modifiée

		foreach ($etapesSuivantes as $etape) {
			$niveauexecCourant += $etape->ponderation;
			$etape->update(['niveauexec' => $niveauexecCourant]);
		}

		$etapes = Etape::where('groupeactivite_id', $groupeid)
			->orderBy('ordre', 'asc')
			->get();
		$niveauexec = 0;

		foreach ($etapes as $e) {
			$niveauexec += $e->ponderation;
			$e->niveauexec = $niveauexec;
			$e->save();
		}

		
        return redirect()->route('groupeactivites.show', $groupeid)->with('success', 'Données mise à jour avec succès.');
    }

    public function destroy($id)
	{
		$etape = Etape::findOrFail($id);

		// Vérification s’il existe des activités validées liées au modèle
		$nbractivites = Activite::where('groupe_id', $etape->groupeactivite_id)
			->where('valide', true)
			->count();

		if ($nbractivites > 0) {
			return redirect()->back()->with('success', 'Impossible, le modèle est lié à une activité validée');
		}
		$modelid = $etape->groupeactivite_id;

		// Suppression de l’étape
		$etape->delete();

		// Réorganisation des ordres et recalcul des niveauexec
		$etapes = Etape::where('groupeactivite_id', $modelid)
			->orderBy('ordre', 'asc')
			->get();
		$ordre = 1;
		$niveauexec = 0;

		foreach ($etapes as $e) {
			// Met à jour l’ordre
			$e->ordre = $ordre;
			// Calcule le niveauexec = somme cumulée des pondérations précédentes
			$niveauexec += $e->ponderation;
			$e->niveauexec = $niveauexec;
			$e->save();
			$ordre++;
		}
		return redirect()->back()->with('success', 'Étape supprimée et niveaux réorganisés avec succès.');
	}

}
