<?php

namespace App\Http\Controllers;

use App\Models\Activite;
use App\Models\GroupeActivite;
use App\Models\Csd;
use Illuminate\Http\Request;

class GroupeActivitesController extends Controller
{
    public function index()
    {
        $groupeactivites = GroupeActivite::orderBy('code')->get();
        return view('groupeactivites.index', compact('groupeactivites'));
    }
	
	public function show($id)
    {
        $groupeactivite = GroupeActivite::with(['etapes', 'csd'])->findOrFail($id);
		$nbractivites = Activite::where('groupe_id', $id)->where('valide', true)->count();
		return view('groupeactivites.show', compact('groupeactivite', 'nbractivites'));
    }

    public function create()
    {
		$csds = Csd::all();
		return view('groupeactivites.create', compact('csds'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:groupeactivites,code',
            'nom' => 'required|string|max:100',
			'csd_id' => 'required|integer',
            'description' => 'nullable|string',
        ]);

        GroupeActivite::create($validated);

        return redirect()->route('groupeactivites.index')->with('success', 'Groupe d’activité ajouté avec succès.');
    }

  public function edit($id)
    {
        $groupeactivite = GroupeActivite::findOrFail($id);
		$csds = Csd::all();
        return view('groupeactivites.edit', compact('groupeactivite', 'csds'));
    }

    public function update(Request $request, $id)
    {
        $groupeactivite = GroupeActivite::findOrFail($id);

        $validated = $request->validate([
            'code' => 'required|string|max:50|unique:groupeactivites,code,' . $groupeactivite->id,
            'nom' => 'required|string|max:150',
			'csd_id' => 'required|integer',
            'description' => 'nullable|string',
        ]);

        $groupeactivite->update($validated);

        return redirect()->route('groupeactivites.index')->with('success', 'Groupe d’activités modifié avec succès.');
    }

    public function destroy($id)
    {
		
		try {
			$groupeactivite = GroupeActivite::findOrFail($id);
			$groupeactivite->delete();
			return redirect()->route('groupeactivites.index')->with('success', 'Type d’activités supprimé avec succès.');

		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
		
        //return redirect()->route('groupeactivites.index')->with('success', 'Groupe d’activités supprimé avec succès.');
    }
	
	public function actif($id)
    {
        $groupeactivite = GroupeActivite::findOrFail($id);
		$groupeactivite->is_active = !$groupeactivite->is_active;
		$groupeactivite->save();

        return redirect()->back()->with('success');
    }
}
