<?php

namespace App\Http\Controllers;

use App\Models\Partenaire;
use App\Models\TypePartenaire;
use Illuminate\Http\Request;

class PartenairesController extends Controller
{
    public function index()
    {
         $partenaires = Partenaire::with(['typepartenaire'])->get();

        return view('partenaires.index', compact('partenaires'));
    }

    public function create()
    {
        $types = TypePartenaire::all();
        return view('partenaires.create', compact('types'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:partenaires,code',
            'nom' => 'required|string|max:100',
            'desctiption' => 'nullable|string',
            'typepartenaire_id' => 'required|exists:typepartenaires,id',
        ]);

        Partenaire::create($validated);

        return redirect()->route('partenaires.index')->with('success', 'Partenaire ajouté avec succès.');
    }

 public function edit($id = 0)
    {
        $types = TypePartenaire::all();
 $partenaire = Partenaire::findOrFail($id);

        return view('partenaires.edit', compact('partenaire', 'types'));
    }

  public function update(Request $request, $id =0)
    {
	$partenaire = Partenaire::findOrFail($id);
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:partenaires,code,' . $partenaire->id,
            'nom' => 'required|string|max:100',
            'desctiption' => 'nullable|string',
            'typepartenaire_id' => 'required|exists:typepartenaires,id',
        ]);

        $partenaire->update($validated);

        return redirect()->route('partenaires.index')->with('success', 'Partenaire mis à jour avec succès.');
    }
     public function destroy($id)
    {
 $partenaire =Partenaire::findOrFail($id);

        $partenaire->delete();
        return redirect()->route('partenaires.index')->with('success', 'Partenaire supprimé avec succès.');
    }
}
