<?php

namespace App\Http\Controllers;

use App\Models\PrevisionActivite;
use App\Models\Activite;
use Illuminate\Http\Request;

class PrevisionActivitesController extends Controller
{
    public function index() {
	 return PrevisionActivite::all(); }
    public function show($id) { 
	return PrevisionActivite::findOrFail($id); }
	
	public function create($activiteid) { 
		$canadd = Activite::select('valide', 'ouvert', 'clos')->where('id', $activiteid)->first();
		
		if($canadd->clos){
			return redirect()->back()->with('error', 'L\'activité est déjà cloturée.');
		}
		if($canadd->valide && $canadd->actif && !$canadd->ouvert){
			return redirect()->back()->with('error', 'L\'activité est validée et fermée aux revisions.');
		}
		
		$lastPrevision = PrevisionActivite::where('activite_id', $activiteid)
			->orderBy('ordreevaluation', 'desc')
			->first();

		$nextOrdre = $lastPrevision ? $lastPrevision->ordreevaluation + 1 : 1;
		
		return view('previsionactivites.create', compact('activiteid', 'nextOrdre')); 
	}

    public function store(Request $request)
    {
		$activiteid = $request->activite_id;
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'ordreevaluation' => 'required|numeric',
			'niveaucible' => 'required|numeric',
            'dateevaluation' => 'required|date',
        ]);
		
		$activite = Activite::findOrFail($activiteid);
		
		if($activite->clos){
			return redirect()->back()->with('error', 'L\'activité est déjà cloturée.');
		}
		
        if ($activite->valide && $activite->actif && !$activite->ouvert) {
			return redirect()->back()->with('error', 'L\'activité est validée et fermée aux prévisions.');
		}
		
		// Récupérer le plus grand taux de prévision avant ou à la même date
		$maxPrevision = PrevisionActivite::where('activite_id', $data['activite_id'])
		->where('dateevaluation', '<=', $data['dateevaluation'])
		->orderBy('niveaucible', 'desc')   // priorité au plus grand niveau
		->orderBy('dateevaluation', 'desc') // si égal, prendre la plus récente
		->first();
		
		if ($maxPrevision && $data['niveaucible'] <= $maxPrevision->niveaucible) {
			return redirect()->back()->withInput()
				->with('error', 'La cible prévisionnelle ne peut pas être inférieure ou égale à celle du '.$maxPrevision->dateevaluation.' ('.$maxPrevision->niveaucible.' %).');
		}
		if ($maxPrevision && $data['ordreevaluation'] <= $maxPrevision->ordreevaluation) {
			return redirect()->back()->withInput()
				->with('error', 'Date ou ordre non cohérent : évaluations (n°'.$maxPrevision->ordreevaluation.' le '.$maxPrevision->dateevaluation.') et (n°'.$data['ordreevaluation'].' le '.$data['dateevaluation'].')');
		}
		
		// Récupérer la dernière prévision après ou à la même date
		$minPrevision = PrevisionActivite::where('activite_id', $data['activite_id'])
		->where('dateevaluation', '>=', $data['dateevaluation'])
		->orderBy('niveaucible', 'asc')   // priorité au plus petit niveau
		->orderBy('dateevaluation', 'asc') // si égal, prendre la plus récente
		->first();
		
		if ($minPrevision && $data['niveaucible'] >= $minPrevision->niveaucible) {
			return redirect()->back()->withInput()
				->with('error', 'La cible prévisionnelle ne peut pas être inférieure ou égale à celle du '.$minPrevision->dateevaluation.' ('.$minPrevision->niveaucible.' %).');
		}
		if ($minPrevision && $data['ordreevaluation'] >= $minPrevision->ordreevaluation) {
			return redirect()->back()->withInput()
				->with('error', 'Date ou ordre non cohérent : évaluations (n°'.$minPrevision->ordreevaluation.' le '.$minPrevision->dateevaluation.') et (n°'.$data['ordreevaluation'].' le '.$data['dateevaluation'].')');
		}
		
		
		$prevision = PrevisionActivite::create($data);
		
		if($prevision) {
			$activite->actif = false; 
			$activite->ouvert = false; 
			$activite->valide = false; 
			$activite->save();
		}
		$this->renumeroterPrevisions($activite->id);
		
		return redirect()
			->route('activites.planning', $activiteid)
			->with('success', 'Prévision enregistrée avec succès.');
	}
	
	public function edit($id) { 
		$previsionactivite = PrevisionActivite::findOrFail($id);
		$activite = Activite::findOrFail($previsionactivite->activite_id);
		
		if($activite->clos){
			return redirect()->back()->with('error', 'L\'activité est déjà cloturée.');
		}
		
		if($activite->valide && !$activite->ouvert){
			return redirect()->back()->with('error', 'L\'activité validée et fermée aux revisions.');
		}
		
		$maxbefore = PrevisionActivite::where('ordreevaluation', '<', $previsionactivite->ordreevaluation)
			->orderBy('ordreevaluation', 'desc')
			->first();

		$minafer = PrevisionActivite::where('ordreevaluation', '>', $previsionactivite->ordreevaluation)
			->orderBy('ordreevaluation', 'asc')
			->first();
		//dd($previsionactivite);die();
		return view('previsionactivites.edit', compact('previsionactivite', 'maxbefore', 'minafer')); 
	}

    public function update(Request $request, $id)
    {
		$data = $request->validate([
            'activite_id' => 'required|integer',
            'ordreevaluation' => 'required|numeric',
            'dateevaluation' => 'required|date',
			'niveaucible' => 'required|numeric',
        ]);
		
		$activite = Activite::findOrFail($data['activite_id']);
		if($activite->clos){
			return redirect()->back()->with('error', 'L\'activité est déjà cloturée.');
		}
		
		// Récupérer le plus grand taux de prévision avant ou à la même date
		$maxPrevision = PrevisionActivite::where('activite_id', $data['activite_id'])
		->where('id', '!=', $id)
		->where('dateevaluation', '<=', $data['dateevaluation'])
		->orderBy('niveaucible', 'desc')   // priorité au plus grand niveau
		->orderBy('dateevaluation', 'desc') // si égal, prendre la plus récente
		->first();
		
		if ($maxPrevision && $data['niveaucible'] <= $maxPrevision->niveaucible) {
			return redirect()->back()->withInput()
				->with('error', 'La cible prévisionnelle ne peut pas être inférieure ou égale à celle du '.$maxPrevision->dateevaluation.' ('.$maxPrevision->niveaucible.' %).');
		}
		if ($maxPrevision && $data['ordreevaluation'] <= $maxPrevision->ordreevaluation) {
			return redirect()->back()->withInput()
				->with('error', 'Date ou ordre non cohérent : évaluations (n°'.$maxPrevision->ordreevaluation.' le '.$maxPrevision->dateevaluation.') et (n°'.$data['ordreevaluation'].' le '.$data['dateevaluation'].')');
		}
		
		// Récupérer la dernière prévision après ou à la même date
		$minPrevision = PrevisionActivite::where('activite_id', $data['activite_id'])
		->where('id', '!=', $id)
		->where('dateevaluation', '>=', $data['dateevaluation'])
		->orderBy('niveaucible', 'asc')   // priorité au plus petit niveau
		->orderBy('dateevaluation', 'asc') // si égal, prendre la plus récente
		->first();
		
		if ($minPrevision && $data['niveaucible'] >= $minPrevision->niveaucible) {
			return redirect()->back()->withInput()
				->with('error', 'La cible prévisionnelle ne peut pas être inférieure ou égale à celle du '.$minPrevision->dateevaluation.' ('.$minPrevision->niveaucible.' %).');
		}
		if ($minPrevision && $data['ordreevaluation'] >= $minPrevision->ordreevaluation) {
			return redirect()->back()->withInput()
				->with('error', 'Date ou ordre non cohérent : évaluations (n°'.$minPrevision->ordreevaluation.' le '.$minPrevision->dateevaluation.') et (n°'.$data['ordreevaluation'].' le '.$data['dateevaluation'].')');
		}
			
        $p = PrevisionActivite::findOrFail($id);
		
        $ok = $p->update($data);
		
		if($ok) {
			$activite->actif = false; 
			$activite->ouvert = false; 
			$activite->valide = false; 
			$activite->save();
		}
        return redirect()
			->route('activites.planning', $activite->id)
			->with('success', 'Prévision enregistrée avec succès.');
    }

    public function destroy($id)
	{
		// Récupérer la prévision à supprimer
		$prevision = PrevisionActivite::findOrFail($id);
		$activite_id = $prevision->activite_id;
		$activite = Activite::findOrFail($activite_id);
		
		$cant_delete = $prevision->evaluations()->exists();
			//dd($cant_delete); die();
		if($cant_delete) {
			return redirect()->back()->with('error', 'Impossible. Prévision liéé à une évaluation');
		}
		
		if($activite->clos){
			return redirect()->back()->with('error', 'L\'activité est déjà cloturée.');
		}
		
		// Supprimer la prévision
		$prevision->delete();

		// Récupérer toutes les prévisions restantes pour cette activité, triées par ordre
		$previsions = PrevisionActivite::where('activite_id', $activite_id)
						->orderBy('ordreevaluation', 'asc')
						->get();

		// Réorganiser les ordres (1, 2, 3, ...)
		$ordre = 1;
		foreach ($previsions as $p) {
			$p->ordreevaluation = $ordre++;
			$p->save();
		}

		return redirect()->back()->with('success', 'Étape supprimée et prévisions réorganisées.');
	}

	
	public function renumeroterPrevisions($activite_id)
	{
		// Récupérer toutes les prévisions de l'activité, triées par date croissante
		$previsions = PrevisionActivite::where('activite_id', $activite_id)
			->orderBy('dateevaluation', 'asc')
			->get();

		// Parcourir et réaffecter les ordres
		$ordre = 1;
		foreach ($previsions as $prevision) {
			// Mettre à jour seulement si l'ordre a changé
			if ($prevision->ordreevaluation != $ordre) {
				$prevision->ordreevaluation = $ordre;
				$prevision->save();
			}
			$ordre++;
		}
	}
}
