<?php

namespace App\Http\Controllers;

use App\Models\Usergroup;
use Illuminate\Http\Request;

class UsergroupsController extends Controller
{
    public function index() { 	
$usergroups  = Usergroup::all();
    return view('usergroups.index', compact('usergroups')); }
    public function show($id) { 	
	return UserGroup::findOrFail($id); }

public function create()
    {
        return view('usergroups.create');
    }
    public function store(Request $request)
    {
        $data = $request->validate([
			'code' => 'required|string|max:10|unique:usergroups,code',
			'nom' => 'required|string|max:30|unique:usergroups,nom',
            'description' => 'nullable|string',
        ]);
        UserGroup::create($data);
	return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur créé avec succès.');
    }
 public function edit($id)
    {
	$usergroup = Usergroup::findOrFail($id);
        return view('usergroups.edit', compact('usergroup'));
    }
    public function update(Request $request, $id)
    {
        $ug = UserGroup::findOrFail($id);
        $data = $request->validate([
			'code' => 'sometimes|string|max:10',
            'nom' => 'sometimes|string|max:30',
            'description' => 'nullable|string',
        ]);
        $ug->update($data);
         return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur mis à jour avec succès.');
    }

    public function destroy($id) { 
	UserGroup::findOrFail($id)->delete(); 
        return redirect()->route('usergroups.index')->with('success', 'Groupe utilisateur supprimé avec succès.');
 }
}

