<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Usergroup;
use App\Models\Programme;
use App\Models\Structure;
use App\Models\ResponsableStructure;
use App\Models\ResponsableProgramme;
use App\Models\Pointfocal;
use Illuminate\Http\Request;

class UsersController extends Controller
{
    public function index() { 
		$users = User::with('usergroup')->get();
        return view('users.index', compact('users')); 
	}
  public function create()
    {
 $usergroups = Usergroup::all(); 
    return view('users.create', compact('usergroups'));
        return view('users.create');
    }


     public function show($id)
    {
        $user = User::with('usergroup')->findOrFail($id);
        return view('users.show', compact('user'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
     'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6',
            'usergroup_id' => 'required|integer',
        ]);
        $data['password'] = bcrypt($data['password']);
         User::create($data);
 return redirect()->route('users.index')->with('success', 'Utilisateur ajouté avec succès.');
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);
        $data = $request->validate([
            'name' => 'sometimes|string|max:255',
            'email' => 'sometimes|email|unique:users,email,'.$id,
            'password' => 'nullable|string|min:6',
            'usergroup_id' => 'sometimes|integer',
        ]);
        if(isset($data['password'])) { $data['password'] = bcrypt($data['password']); }
        $user->update($data);
         return redirect()->route('users.index')->with('success', 'Utilisateur modifié avec succès.');
    }
	public function edit($id)
    {
       $user = User::findOrFail($id);
    $usergroups = Usergroup::all();
    return view('users.edit', compact('user', 'usergroups'));
        
    }

    public function destroy($id) { 
	User::findOrFail($id)->delete(); 
	 return redirect()->route('users.index')->with('success', 'Utilisateur supprimé avec succès.');
	 }
	public function actif($id)
    {
        $user = User::findOrFail($id);
        $user->is_active = !$user->is_active;
        $user->save();

        return redirect()->route('users.index')->with('success', 'État de l\'utilisateur mis à jour.');
    }
	public function rpcreate($level, $id)
    {
        //$users = User::with('usergroup')->get();
		
		if($level == "program"){
			$users = User::whereHas('usergroup', function ($query) {$query->where('code', 'RP');})->where('is_rp', false)->with('usergroup')->get();
			//dd($users,$level, $id); die();
			return view('users.rpcreate', compact('users', 'level', 'id'));
		}
    }
	
	public function rpadd($level, $levelid, $userid)
    {
		//dd($level, $levelid, $userid); die();
		if($level == "program"){
			$programme = Programme::with('user')->findOrFail($levelid);
			//dd($programme); die();
			$oldrp = $programme->user_id;
			if($oldrp == $userid){
				return redirect()->route('programmes.show', $levelid)->with('success', 'Mise à jour effectuée.');
			}
			$programme->user_id = $userid;
			$resprog = ResponsableProgramme::where('programme_id', $levelid)->orderBy('id', 'desc')->first();
			
			if($programme->save()){
				//mettre fin au mandat de l'ancien
				if(isset($resprog)){
					$resprog->datefin = now();
					$resprog->save();
					
					$user = User::find($resprog->user_id);
					$user->is_rp = false;
					$user->save();
				}
				// enregistrer le nouveau
				$programme = Programme::with('user')->findOrFail($levelid);
				$resprog = new ResponsableProgramme();
				$resprog->programme_id = $levelid;
				$resprog->user_id = $userid;
				$resprog->programme = $programme->code.' : '.$programme->nom;
				$resprog->user = $programme->user->name.' ('. $programme->user->email. ')';
				$resprog->datedebut = now();
				$resprog->save();
				
				$user = User::find($userid);
				$user->is_rp = true;
				$user->save();
			};
			
			return redirect()->route('programmes.show', $levelid)->with('success', 'Mise à jour effectuée.');
		}
		if($level == "respstruct"){
			$respstructure = ResponsableStructure::where('structure_id', $levelid)->orderBy('id', 'desc')->first();
			if(isset($respstructure)){
				$respstructure->datefin = now();
				$respstructure->save();
			}
			$respstructure = new ResponsableStructure();
			$respstructure->user_id = $userid;
			$respstructure->structure_id = $levelid; 
			$respstructure->datedebut = now();
			$respstructure->save();
			return redirect()->route('structure.index')->with('success', 'Mise à jour effectuée.');
		}
		if($level == "ptfocal"){
			$ptfocal = Pointfocal::where('structure_id', $levelid)->orderBy('id', 'desc')->first();
			if(isset($ptfocal)){
				$ptfocal->datefin = now();
				$ptfocal->save();
			}
			$ptfocal = new Pointfocal();
			$ptfocal->user_id = $userid;
			$ptfocal->structure_id = $levelid; 
			$ptfocal->datedebut = now();
			$ptfocal->save();
			return redirect()->route('structure.index', $levelid)->with('success', 'Mise à jour effectuée.');
		}
		/*if($level == "structaction"){
			$structureaction = new StructureAction();
			$structureaction->action_id = $levelid;
			$structureaction->action_id = $userid;
			
			$programme->user_id = $userid;
			$programme->save();
			return redirect()->route('actions.show', $levelid)->with('success', 'Mise à jour effectuée.');
		}*/
    }
}

