<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Programme extends Model
{
    use HasFactory;

    protected $table = 'programmes';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'description',
        'actif',
        'ouvert',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;
	
	protected static function boot()
    {
        parent::boot();

        static::deleting(function ($groupe) {
            if ($groupe->actions()->exists()) {
                throw new \Exception("Suppression impossible : ce programme possède encore des actions associées.");
            }
        });
    }

    // Relation avec Actions
    public function actions()
    {
        return $this->hasMany(Action::class, 'programme_id', 'id');
    }

    // Relation avec ResponsableProgrammes
    public function responsables()
    {
        return $this->hasMany(ResponsableProgramme::class, 'programme_id', 'id');
    }
	public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
