<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\GroupeActivite;

class GroupeActiviteSeeder extends Seeder
{
    public function run(): void
    {
        $groupes = [
            [
                'code' => 'GA001',
                'nom' => 'Formation et renforcement de capacités',
                'description' => 'Activités liées aux sessions de formation et de transfert de compétences.',
            ],
            [
                'code' => 'GA002',
                'nom' => 'Infrastructure et équipements',
                'description' => 'Projets relatifs aux travaux, constructions et dotations matérielles.',
            ],
            [
                'code' => 'GA003',
                'nom' => 'Sensibilisation et communication',
                'description' => 'Activités de sensibilisation, communication et plaidoyer.',
            ],
        ];

        foreach ($groupes as $groupe) {
            GroupeActivite::create($groupe);
        }
    }
}
