@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
      <h1>Actions</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active"Actions</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
 <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
            @php
    $usergroupId = Auth::user()->usergroup_id;
@endphp
@if($usergroupId != 3)
	              <h5 class="card-title"><a href="{{ route('actions.create') }}" class="btn btn-primary rounded-pill">
    <i class="bi bi-plus-circle"></i> Ajouter
</a>
</h5>
@endif

  

              <!-- Table with stripped rows -->
             <table class="table datatable">
  <thead>
    <tr>
      <th>Code & Nom</th>
      <th>Programme</th>
      <th>Actif</th>
<th>Ouvert</th>
     
     
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    @foreach($actions as $action)
      <tr>
        <td>{{ $action->code }} : {{ $action->nom }}</td>
        <td>{{ $action->programme->nom ?? 'Non défini' }}</td>
       
        <td>
 <a href="{{ route('actions.actif', $action->id) }}" 
               class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}">
              {{ $action->actif ? 'Oui' : 'Non' }}
            </a>       
       </td>
         <td>
            <a href="{{ route('actions.ouvert', $action->id) }}" 
               class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}">
              {{ $action->ouvert ? 'Ouvert' : 'Fermé' }}
            </a>
          </td>
   <td>
 <a href="{{ route('actions.show', $action->id) }}" class="btn btn-info"><i class="bi bi-eye"></i></a>
@if($action->ouvert)          
<a href="{{ route('actions.edit', $action->id) }}" class="btn btn-warning">
            <i class="bi bi-pen"></i>
          </a>
          @if($usergroupId != 3)
	<a href="{{ route('actions.destroy', $action->id) }}"
   class="btn btn-danger"
   onclick="return confirm('Supprimer cette action ?')">
   <i class="bi bi-trash"></i>
</a>
@endif
@endif



        </td>
      </tr>
    @endforeach
  </tbody>
</table>

              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>
@endsection

