@extends('layouts.app')
@section('title', 'Évaluation Activité')

@section('content')
<div class="pagetitle">
    <h1>Détails Activité</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('activites.show', $activite->id) }}">Détails Activité</a></li>
            <li class="breadcrumb-item active">Évaluation</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Détails de l'activité</h5>

                    {{-- Messages de succès --}}
                    @if(session('status'))
                        <div class="alert alert-success text-center">{{ session('status') }}</div>
                    @endif

                    {{-- Informations générales --}}
                    <h2>Détails : <strong>{{ $activite->nom }}</strong></h2>
                    <hr>
                    <div class="callout callout-primary">
                        <h5><b><u>Informations générales</u></b></h5>
                        <ul class="list-group list-group-unbordered mb-3">
                            <li class="list-group-item"><b>Code :</b> <span class="float-right">{{ $activite->code }}</span></li>
                            <li class="list-group-item"><b>Nom :</b> <span class="float-right">{{ $activite->nom }}</span></li>
                            <li class="list-group-item"><b>Description :</b> <span class="float-right">{{ $activite->description ?? '-' }}</span></li>
                            <li class="list-group-item"><b>Montant :</b> <span class="float-right">{{ $activite->montant ?? '-' }}</span></li>
                            <li class="list-group-item"><b>Date Début :</b> <span class="float-right">{{ $activite->datedebut }}</span></li>
                            <li class="list-group-item"><b>Date Fin :</b> <span class="float-right">{{ $activite->datefin ?? 'En cours' }}</span></li>
                            <li class="list-group-item">
                                <b>État :</b>
                                <span class="fw-bold text-{{ $activite->valide ? 'success' : 'danger' }}">{{ $activite->valide ? 'Validée' : 'Non validée' }}</span> |
                                <span class="fw-bold text-{{ $activite->actif ? 'success' : 'danger' }}">{{ $activite->actif ? 'Activée' : 'Non activée' }}</span> |
                                <span class="fw-bold text-{{ $activite->ouvert ? 'success' : 'primary' }}">{{ $activite->ouvert ? 'Révision/Élaboration' : 'Suivi/Évaluation' }}</span>
                            </li>
                        </ul>
                    </div>

                    <hr>

                    {{-- Nouvelle évaluation --}}
                    <div class="callout callout-primary">
                        <h5><b><u>Nouvelle évaluation</u></b></h5>
                        <table class="table table-bordered" id="evaluationTable">
                            <thead class="table-light">
                                <tr>
                                    <th>Date de référence</th>
                                    <th>Prévision</th>
                                    <th>Réalisation</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
								@foreach($evalwaitings as $toeval)
									<tr data-prevision-id="{{ $toeval->id }}" data-activite-id="{{ $activite->id }}">
										<td class="date-reference">{{ $toeval->dateevaluation }}</td>
										<td class="taux-prevision">{{ $toeval->niveaucible }}</td>
										<td>
											<select class="form-control etape-select" disabled>
												<option value="">-- Choisir une étape --</option>
												@foreach($activite->etapes as $etape)
													<option value="{{ $etape->id }}" data-taux="{{ $etape->niveauexec }}">
														{{ $etape->nom }} ({{ $etape->niveauexec }}%)
													</option>
												@endforeach
											</select>
										</td>
										<td>
										@php
											$canEvaluate = ($evalwaitings->isNotEmpty() && $activite->valide && $activite->actif && !$activite->ouvert);
										@endphp
										@if($canEvaluate)
											<button class="btn btn-warning btn-sm eval-btn">À Évaluer</button>
											<button class="btn btn-success btn-sm ok-btn d-none">OK</button>
											<button class="btn btn-primary btn-sm valider-btn d-none">Valider</button>
										@endif
										</td>
									</tr>
								@endforeach
							</tbody>
                        </table>
                    </div>

                    <hr>

                    {{-- Evaluations effectuée--}}
                    <div class="callout callout-primary">
                        <h5><b><u>Anciennes évaluations</u></b></h5>
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Date de référence</th>
                                    <th>Prévision</th>
                                    <th>Réalisation</th>
                                    <th>Validé</th>
									<th></th>
                                    <th>Commentaire</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($activite->evaluations as $eval)
                                    <tr>
                                        <td>{{ $eval->prevision->dateevaluation ?? '-' }}</td>
                                        <td>{{ $eval->prevision->niveaucible ?? '-' }} %</td>
                                        <td>{{ $eval->taux_realisation ?? '-' }} %</td>
										<td>
										@if($eval->valide)
											<button class="btn btn-sm {{ $activite->valide ? 'btn-success' : 'btn-secondary' }}" disabled>
												{{ $eval->valide ? 'OUI' : 'NON' }}
											</button>
										@else
											<a href="{{ route('evaluations.valider', $eval->id) }}" 
											class="btn btn-sm {{ $eval->valide ? 'btn-success' : 'btn-secondary' }}">
											{{ $eval->valide ? 'OUI' : 'NON' }}</a>
										@endif
										</td>
										<td>
										@if(!$eval->valide)
											<a href="{{ route('evaluations.edit', $eval->id) }}" class="btn btn-warning"><i class="bi bi-pen"></i></a>
											<a href="{{ route('evaluations.destroy', $eval->id) }}" class="btn btn-danger" onclick="return confirm('Supprimer ?')"><i class="bi bi-trash"></i></a>
										@endif
										</td>
                                        <td>{{ $eval->commentaire ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {

    const log = (msg) => console.log("%c[DEBUG ÉVAL] " + msg, "color: #0a58ca");

    // --- Bouton "À Évaluer" ---
    document.querySelectorAll('.eval-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            const row = btn.closest('tr');
            const select = row.querySelector('.etape-select');
            const okBtn = row.querySelector('.ok-btn');

            select.disabled = false;
            btn.classList.add('d-none');
            okBtn.classList.remove('d-none');

            log("Mode évaluation activé pour la ligne " + row.dataset.previsionId);
        });
    });

    // --- Bouton "OK" ---
    document.querySelectorAll('.ok-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            const row = btn.closest('tr');
            const activiteId = row.dataset.activiteId;
            const previsionId = row.dataset.previsionId;
            const select = row.querySelector('.etape-select');
            const evalBtn = row.querySelector('.eval-btn');
            const validerBtn = row.querySelector('.valider-btn');

            const etapeId = select.value;
            const tauxRealisation = parseFloat(select.options[select.selectedIndex]?.dataset.taux);

            if (!etapeId) {
                alert("Veuillez choisir une étape avant d'enregistrer !");
                return;
            }

            // ➤ Récupération du taux de prévision depuis la cellule correspondante (sans %)
            let tauxPrevisionText = row.querySelector('.taux-prevision')?.innerText?.trim() || "0";
            const tauxPrevision = parseFloat(tauxPrevisionText.replace('%','').trim());

            // ➤ Récupération de la date de référence
            const dateReference = row.querySelector('.date-reference')?.innerText?.trim();

            const logMessage = `Envoi des données : activité=${activiteId}, prévision=${previsionId}, étape=${etapeId}, taux_prev=${tauxPrevision}, taux_real=${tauxRealisation}, date_ref=${dateReference}`;
            console.log("%c[DEBUG ÉVAL] " + logMessage, "color: #0a58ca");

            //alert("Données à envoyer :\n" + logMessage + "\n\nL'envoi commencera dans 20 secondes...");

            setTimeout(() => {	 
                // --- URL dynamique pour le fetch ---
                const url = "{{ route('evaluations.store', ['activiteid' => 'ACTIVITE_ID']) }}".replace('ACTIVITE_ID', activiteId);

                fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        activite_id: activiteId,
                        previsionactivite_id: previsionId,
                        etape_id: etapeId,
                        taux_realisation: tauxRealisation,
                        taux_prevision: tauxPrevision,
                        date_evaluation: dateReference
                    })
                })
                .then(res => res.json())
                .then(data => {
                    log("Réponse du serveur : " + JSON.stringify(data));

                    if (data.success) {
                        alert("✅ Évaluation enregistrée avec succès !");
                        select.disabled = true;
                        btn.classList.add('d-none');   // cache "OK"
                        validerBtn.classList.remove('d-none'); // montre "Valider"
						// ➤ Cacher le bouton "À Évaluer"
						const evalBtn = row.querySelector('.eval-btn');
						if (evalBtn) evalBtn.classList.add('d-none');
						row.remove();
                    } else {
                        alert("Erreur : " + (data.message || "Impossible d'enregistrer"));
                    }
                })
                .catch(err => {
                    console.error(err);
                    alert("❌ Une erreur s'est produite lors de l'enregistrement.");
                });
				window.location.href = "{{ route('redirect.delayed', $activite->id) }}?t=" + new Date().getTime();
            }, 500); // 500 ms 
        });
    });

    // --- Bouton "Valider" ---
    document.querySelectorAll('.valider-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            const row = btn.closest('tr');
            const previsionId = row.dataset.previsionId;

            log("Recherche évaluation pour prévision " + previsionId);

            const findUrl = "{{ url('evaluations/find-by-prevision/ID') }}".replace('ID', previsionId);

            fetch(findUrl)
                .then(res => res.json())
                .then(data => {
                    log("Évaluation trouvée : " + JSON.stringify(data));
                    if (data.success) {
                        const evaluationId = data.id;
                        const validerUrl = "{{ url('evaluations/ID/valider') }}".replace('ID', evaluationId);

                        fetch(validerUrl, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            }
                        })
                        .then(res => res.json())
                        .then(result => {
                            if (result.success) {
                                alert("✅ Évaluation validée !");
                                btn.classList.add('d-none');
                                row.style.backgroundColor = '#e8f5e9';
                                const badge = document.createElement('span');
                                badge.className = "badge bg-success ms-2";
                                badge.innerText = "Validée ✅";
                                row.querySelector('td:last-child').appendChild(badge);
                            } else {
                                alert("Erreur : " + result.message);
                            }
                        });
                    } else {
                        alert("Aucune évaluation trouvée pour cette prévision !");
                    }
                });
        });
    });
});
</script>
@endsection


@endsection
