@extends('layouts.app')
@section('title', 'Activité')

@section('content')
<div class="pagetitle">
    <h1>Prévisions Activité</h1>
	<h5>Pour ajouter une étape l'activité doit modifiable (etats : invalide, inactif ou ouvert)</h5>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('activites.show', $activite->id) }}">Détails Activité</a></li>
            <li class="breadcrumb-item active">Planning des prévisions</li>
        </ol>
    </nav>
</div><!-- End Page Title -->

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Détails de l'activité</h5>

                    @if(Session::has('status'))
                        <div class="col-md-3" style="margin-left:15%">
                            <div class="card card-success shadow-sm">
                                <div class="card-header">
                                    <h3 class="card-title">Correct</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    {{ Session::get('status') }}
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="card-body">
                        <h4>Détails : <strong>{{ $activite->nom }}</strong></h4>
                        <hr>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="callout callout-primary">
                                    <h5><b><u>Informations générales</u></b></h5>
                                    <ul class="list-group list-group-unbordered mb-3">
                                        <li class="list-group-item">
                                            <b>Code :</b> <span class="float-right">{{ $activite->code }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Nom :</b> <span class="float-right">{{ $activite->nom }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Description :</b> <span class="float-right">{{ $activite->description ?? '-' }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Montant :</b> <span class="float-right">{{ $activite->montant ?? '-' }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Date Début :</b> <span class="float-right">{{ $activite->datedebut }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Date Fin :</b> <span class="float-right">{{ $activite->datefin ?? 'En cours' }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Etat :</b> 
											<span style="color: {{ $activite->valide ? 'green' : 'red' }}; font-weight: bold;">
												{{ $activite->valide ? 'Validée' : 'Non validée' }}
											</span> |
											<span style="color: {{ $activite->actif ? 'red' : 'green' }}; font-weight: bold;">
												{{ $activite->actif ? 'Activée' : 'Non activée' }}
											</span> |
											<span style="color: {{ $activite->ouvert ? 'green' : 'blue' }}; font-weight: bold;">
												{{ $activite->ouvert ? 'Révision ou élaboration' : 'Pas de modification' }}
											</span>
										</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
						
                        <hr>
						
                        <hr>
						{{-- Planning --}}
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Planning</u></b></h5>
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>Ordre</th>
											<th>Date de référence</th>
                                            <th>Taux </th>
                                            <th>Commentaire</th>
                                        </tr>
                                    </thead>
                                    <tbody>
										@php
											$canAddplanning = $activite->ouvert || !$activite->actif || !$activite->valide;
										@endphp
										@if($canAddplanning)
											<h6 class="card-title">
												<a href="{{ route('previsionactivites.create', ['activiteid' => $activite->id]) }}" 
												   class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter un Planning
												</a>
											</h6>
										@endif
                                        @foreach($activite->previsions as $prev)
                                            <tr>
                                                <td>{{ $prev->ordreevaluation ?? '-' }}</td>
												<td>{{ $prev->dateevaluation }}</td>
                                                <td>{{ $prev->niveaucible }} %</td>
                                                <td>{{ $eval->commentaire ?? '-' }}</td>
												@if($canAddplanning)
												<td>
													<a href="{{ route('previsionactivites.edit', $prev->id) }}" class="btn btn-warning"><i class="bi bi-pen"></i></a>
													<a href="{{ route('previsionactivites.destroy', $prev->id)}}"> 
													<i class="bi bi-danger" onclick="return confirm('Enlever cette étape de planning?')">
														<i class="bi bi-trash"></i>
													</i> </a>
												</td>
												@endif
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
						<div class="row">
							<div class="callout callout-primary d-flex align-items-center gap-3">
								@php
									$canEvaluate = ($evalwaitings->isNotEmpty() && $activite->valide && $activite->actif && !$activite->ouvert);
								@endphp

								@if($canEvaluate)
									<a href="{{ route('activites.evaluate', ['id' => $activite->id]) }}" 
									   class="btn btn-success rounded-pill">
										<i class="bi bi-clipboard-check"></i> Évaluation
									</a>
								@endif
							</div>
						</div>
                    </div> <!-- End card-body -->
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
