@extends('layouts.app')

@section('content')
<div class="container text-center mt-5">
    <h3 class="text-success">✅ Évaluation enregistrée avec succès !</h3>
    <p>Redirection automatique vers la page d’évaluation dans <span id="countdown">5</span> secondes...</p>

    <div class="spinner-border text-primary mt-3" role="status">
        <span class="visually-hidden">Chargement...</span>
    </div>

    <script>
        let seconds = 5;
        const countdown = document.getElementById('countdown');

        const timer = setInterval(() => {
            seconds--;
            countdown.textContent = seconds;

            if (seconds <= 0) {
                clearInterval(timer);
                // Redirection automatique
                window.location.href = "{{ route('activites.evaluate', $activiteId) }}";
            }
        }, 1000);
    </script>
</div>
@endsection
