<?php

namespace App\Http\Controllers;

use App\Models\Evaluation;
use App\Models\Etape;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;

class EvaluationsController extends Controller
{
	public function index() {
		$evaluations = Evaluation::with('activite', 'prevision', 'etape')
			->orderBy('date_reference', 'asc')
			->get();
		//dd($evaluations); die();
		return view('evaluations.index', compact('evaluations')); 
	}
    public function show($id) {
	return Evaluation::findOrFail($id); }

	
	/* public function create($activiteid) { 
		$canadd = Activite::select('valide', 'ouvert')->where('id', $activiteid)->first();
		if($canadd->valide && !$canadd->ouvert){
			return redirect()->back()->with('error', 'L\'activité validée et fermée aux revisions.');
		}
		
		$lastPrevision = PrevisionActivite::where('activite_id', $activiteid)
			->orderBy('ordreevaluation', 'desc')
			->first();

		$nextOrdre = $lastPrevision ? $lastPrevision->ordreevaluation + 1 : 1;
		
		return view('previsionactivites.create', compact('activiteid', 'nextOrdre')); 
	} */
	
	public function create(Request $request, $activiteId)
	{
		$data = $request->all(); // <-- récupère toutes les données envoyées via fetch JSON
		//dd($data); die();
		// Validation
		$validator = Validator::make($data, [
			'previsionactivite_id' => 'nullable|integer|exists:previsionactivites,id',
			'etape_id' => 'nullable|integer|exists:etapes,id',
			'taux_prevision' => 'required|numeric',
			'taux_realisation' => 'required|numeric',
			'date_evaluation' => 'nullable|date',
		]);

		if ($validator->fails()) {
			return response()->json([
				'success' => false,
				'errors' => $validator->errors()
			], 422);
		}

		$evaluation = Evaluation::create([
			'activite_id' => $activiteId,
			'previsionactivite_id' => $data['previsionactivite_id'] ?? null,
			'etape_id' => $data['etape_id'] ?? null,
			'date_evaluation' => now(),
			//'date_evaluation' => $data['date_evaluation'] ?? null,
			'taux_prevision' => $data['taux_prevision'],
			'taux_realisation' => $data['taux_realisation'],
			'commentaire' => null,
		]);

		return response()->json([
			'success' => true,
			'evaluation_id' => $evaluation->id,
			'message' => 'Évaluation enregistrée avec succès'
		]);
	}

    public function store(Request $request, $activiteId)
	{
		try {
			// Récupérer les données JSON correctement
			$data = $request->json()->all();

			Log::info('Tentative d’enregistrement évaluation', $request->all());

			// Validation
			$validated = validator($data, [
				'previsionactivite_id' => 'required|integer',
				'etape_id' => 'required|integer',
				'taux_prevision' => 'required|numeric',
				'taux_realisation' => 'required|numeric',
				//'date_evaluation' => 'required|date',
				'date_reference' => 'sometimes|date',
				'date_evaluation' => 'nullable|date',
			])->validate();

			$evaluation = Evaluation::create([
				'activite_id' => $activiteId,
				'previsionactivite_id' => $validated['previsionactivite_id'],
				'etape_id' => $validated['etape_id'],
				'taux_prevision' => $validated['taux_prevision'],
				'taux_realisation' => $validated['taux_realisation'],
				'date_reference' => $validated['date_reference'],
				'date_evaluation' => now(),
				'valide' => false,
				'commentaire' => null,
				'created_at' => now(),
			]);

			Log::info('Évaluation créée avec succès', ['id' => $evaluation->id]);

			return response()->json(['success' => true, 'id' => $evaluation->id]);
		} catch (\Exception $e) {
			Log::error('Erreur enregistrement évaluation', ['message' => $e->getMessage()]);
			return response()->json(['success' => false, 'message' => $e->getMessage()]);
		}
	}


    /**
     * Recherche une évaluation par prévision
     */
    public function findByPrevision($previsionId)
    {
        $evaluation = Evaluation::where('previsionactivite_id', $previsionId)->first();

        if ($evaluation) {
            return response()->json(['success' => true, 'id' => $evaluation->id]);
        }
        return response()->json(['success' => false]);
    }

    /**
     * Validation d’une évaluation
     */
    public function valider($id)
    {
        try {
            $evaluation = Evaluation::findOrFail($id);
            $evaluation->valide = true;
            $evaluation->updated_at = now();
            $evaluation->save();

           return redirect()->back()->with('success', 'Évaluation validée.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Échec d\'activation.');
        }
    }

	public function edit($id)
	{
		$evaluation = Evaluation::with('activite', 'prevision')->findOrFail($id);
		$etapes = Etape::where('groupeactivite_id', $evaluation->activite->groupe_id)->get();
		
		if($evaluation->valide){
			return redirect()->back()->with('error', 'Impossible car l\'evaluation est déjà validée.');
		}
		
		return view('evaluations.edit', compact('evaluation', 'etapes')); 
	}


    public function update(Request $request, $id)
    {
        $eval = Evaluation::findOrFail($id);
		if($eval->valide){
			return redirect()->back()->with('error', 'Impossible car l\'evaluation est déjà validée.');
		}
        $data = $request->validate([
            'activite_id' => 'required|integer',
            'etape_id' => 'required|integer',
            'previsionactivite_id' => 'required|integer',
			'date_reference' => 'sometimes|date',
			'date_evaluation' => 'nullable|date',
            'commentaire' => 'nullable|string',
        ]);
		$data['taux_realisation'] = $niveauExec = Etape::where('id', $data['etape_id'])->value('niveauexec');
		$data['date_evaluation'] = now();
		
        if($eval->update($data)) {
			return redirect()
				->route('activites.evaluate', $eval->activite_id)
				->with('success', 'Données mise à jour avec succès.');
		}else{
			return redirect()->back()->with('error', 'Echec.');
		}
        
    }

    public function destroy($id) {
		
		$evaluation = Evaluation::findOrFail($id);
		if($evaluation->valide){
			return redirect()->back()->with('error', 'Echec, évaluation déjà validé.');
		}
		
		if($evaluation->delete())
		{
			return redirect()
					->route('activites.evaluate', $evaluation->activite_id)
					->with('success', 'Données supprimées avec succès.');
		}else {
			return redirect()->back()->with('error', 'Echec.');
		}
	}
}
