<?php

namespace App\Http\Controllers;

use App\Models\Extrant;
use Illuminate\Http\Request;

class ExtrantsController extends Controller
{
    public function index() { 
	return Extrant::all(); }
    public function show($id) {
	 return Extrant::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required|string|max:100',
            'activite_id' => 'required|integer',
        ]);
        return Extrant::create($data);
    }

    public function update(Request $request, $id)
    {
        $e = Extrant::findOrFail($id);
        $data = $request->validate([
            'nom' => 'sometimes|string|max:100',
            'activite_id' => 'sometimes|integer',
        ]);
        $e->update($data);
        return $e;
    }

    public function destroy($id) {
	 Extrant::findOrFail($id)->delete();
	 return response()->json(['message'=>'Extrant supprimé']); }
}
