<?php

namespace App\Http\Controllers;

use App\Models\Ministere;
use Illuminate\Http\Request;

class MinisteresController extends Controller
{
    public function index()
    {
        $ministeres = Ministere::all();
        return view('ministeres.index', compact('ministeres'));
    }

    public function create()
    {
        return view('ministeres.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:ministeres,code',
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
        ]);

        Ministere::create($validated);

        return redirect()->route('ministeres.index')->with('success', 'Ministère ajouté avec succès.');
    }

    public function edit($id = 0)
    {
$ministere = Ministere::find($id);

        return view('ministeres.edit', compact('ministere'));
    }

public function update(Request $request, $id)
{
    $ministere = Ministere::findOrFail($id);

    $validated = $request->validate([
        'code' => 'required|string|max:20',
        'nom' => 'required|string|max:100',
        'description' => 'nullable|string',
    ]);

    $ministere->update($validated);

    return redirect()->route('ministeres.index')->with('success', 'Ministère mis à jour avec succès.');
}

	public function destroy($id) {
		try {
			$ministere =Ministere::findOrFail($id);
			$ministere->delete();
			return redirect()->route('ministeres.index')->with('success', 'Ministere supprimé avec succès.'); 
		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
	} 
}

