<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckAdminAccess
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
		 if (!$user) {
            abort(403, 'Accès refusé : utilisateur non connecté.');
        }

        $groupId = $user->usergroup_id;

        // Si c’est le superadmin (id groupe = 2)
        if ($groupId == 2) {
            // Bloque l’accès à l’administration
            if (
                $request->is('usergroups*') ||
                $request->is('users*') ||
                $request->is('evenements*') ||
                $request->is('admin*')
            ) {
                abort(403, 'Accès interdit à la section Administration.');
            }
			return $next($request);
        }
		 if ($groupId == 3) {
            // Plein accès à l'administration et aux paramètres
            if ($request->is('admin*') || 
            $request->is('structures*') || 
            $request->is('ministeres*') || 
            $request->is('ministeres*') || 
            $request->is('csds*') || 
            $request->is('groupeactivitess*') || 
            $request->is('partenaires*') ||
             $request->is('usergroups*') ||
                $request->is('users*') ||
                $request->is('evenements*') 
            ) {
                return $next($request);
            }

            // Lecture seule pour le reste
            if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
                return $next($request);
            }
            // Interdire les autres méthodes HTTP (POST, PUT, DELETE)
            abort(403, 'Lecture seule pour cet utilisateur.');
        }

        if ($groupId == 4) {
        
           if (
                $request->is('admin*') ||
                $request->is('structures*') ||
                $request->is('ministeres*') ||
                $request->is('csds*') ||
                $request->is('groupeactivites*') ||
                $request->is('partenaires*') ||
                $request->is('usergroups*') ||
                $request->is('users*') ||
                $request->is('evenements*') ||
                $request->is('indicateurs*')
            ) {
                abort(403, 'Accès interdit à la section Administration ou Paramètres.');
            }

            // Plein accès sur les actions et résultats de SON programme
            if ($request->is('actions*') || $request->is('resultats*')) {
                return $next($request);
            }

            // Lecture seule sur les activités de son programme
            if ($request->is('activites*')) {
                if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
                    return $next($request);
                }
                abort(403, 'Vous ne pouvez pas modifier les activités.');
            }

            // Peut modifier son programme, mais pas l’activer, le désactiver, l’ouvrir ou le fermer
            if ($request->is('programmes*')) {
                // Interdit d’activer, désactiver ou fermer
                if (
                    $request->is('programmes/*/fonctactif') ||
                    $request->is('programmes/*/fonctouvert') 
                ) {
                    abort(403, 'Seule la DGESS peut activer ou fermer un programme.');
                }

                // Interdit de supprimer
                if ($request->isMethod('DELETE')) {
                    abort(403, 'Vous ne pouvez pas supprimer un programme.');
                }

                // Sinon modification autorisée
                return $next($request);
            }

            // Lecture seule sur tout le reste
            if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
                return $next($request);
            }

            abort(403, 'Accès restreint pour votre profil Program Manager.');
        }

        // === 4️⃣ Autres groupes ===
        return $next($request);

        
    }
}

