<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Extrant extends Model
{
    use HasFactory;

    protected $table = 'extrants';
    protected $primaryKey = 'id';

    protected $fillable = [
        'nom',
        'activite_id',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function activite()
    {
        return $this->belongsTo(Activite::class, 'activite_id', 'id');
    }
}
