<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Structure;
use Illuminate\Support\Str;

class StructureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
 
        $structures = [
            [
                'code' => 'STR001',
                'nom' => 'Direction Générale',
                'description' => 'Structure centrale de gestion',
                'ministere_id' => 1,
            ],
            [
                'code' => 'STR002',
                'nom' => 'Service Financier',
                'description' => 'Gestion des finances',
                'ministere_id' => 1,
            ],
            [
                'code' => 'STR003',
                'nom' => 'Service RH',
                'description' => 'Gestion des ressources humaines',
                'ministere_id' => 2,
            ],
            [
                'code' => 'STR004',
                'nom' => 'Service Informatique',
                'description' => 'Support et développement IT',
                'ministere_id' => 2,
            ],
            [
                'code' => 'STR005',
                'nom' => 'Service Communication',
                'description' => 'Communication interne et externe',
                'ministere_id' => 3,
            ],
        ];

 
        foreach ($structures as $structure) {
            Structure::create($structure);
        }
    }
}
