@extends('layouts.app')
@section('title', 'Activité')

@section('content')
<div class="pagetitle">
    <h1>Détails Activité</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('actions.show', $activite->action_id) }}">Détails Action</a></li>
            <li class="breadcrumb-item active">Détails Activité</li>
        </ol>
    </nav>
</div><!-- End Page Title -->

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Détails de l'activité</h5>

                    @if(Session::has('status'))
                        <div class="col-md-3" style="margin-left:15%">
                            <div class="card card-success shadow-sm">
                                <div class="card-header">
                                    <h3 class="card-title">Correct</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    {{ Session::get('status') }}
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="card-body">
                        <h2>Détails : <strong>{{ $activite->nom }}</strong></h2>
                        <hr>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="callout callout-primary">
                                    <h5><b><u>Informations générales</u></b></h5>
                                    <ul class="list-group list-group-unbordered mb-3">
                                        <li class="list-group-item">
                                            <b>Code :</b> <span class="float-right">{{ $activite->code }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Nom :</b> <span class="float-right">{{ $activite->nom }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Description :</b> <span class="float-right">{{ $activite->description ?? '-' }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Montant :</b> <span class="float-right">{{ $activite->montant ?? '-' }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Date Début :</b> <span class="float-right">{{ $activite->datedebut }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Date Fin :</b> <span class="float-right">{{ $activite->datefin ?? 'En cours' }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>Actif :</b> 
                                            @if((Auth::user()->usergroup_id == 4) || (!$activite->valide))
                                                <button class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
                                                    {{ $activite->actif ? 'OUI' : 'NON' }}
                                                </button>
                                            @else
												 <a href="{{ route('activites.actif', $activite->id) }}" 
													class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}">
													{{ $activite->actif ? 'OUI' : 'NON' }}
												</a>
											@endif
                                        </li>
                                        <li class="list-group-item">
                                            <b>Ouvert :</b> 
                                            @if((Auth::user()->usergroup_id == 4) || (!$activite->valide))
                                                <button class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
                                                    {{ $activite->ouvert ? 'OUI' : 'NON' }}
                                                </button>
                                            @else
												<a href="{{ route('activites.ouvert', $activite->id) }}" 
													class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}">
													{{ $activite->ouvert ? 'OUI' : 'NON' }}
												</a>
											@endif
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
						<div class="row">
                            <div class="col-md-10">
                                <div class="callout callout-primary">
                                    <h5><b><u>ETAT DE VALIDATION :</u></b></h5>
                                    <ul class="list-group list-group-unbordered mb-3">
                                        <li class="list-group-item">
										<b>ETAT :</b>
											@if(Auth::user()->usergroup_id == 4)
												<button class="btn btn-sm {{ $activite->valide ? 'btn-success' : 'btn-secondary' }}" disabled>
                                                    {{ $activite->valide ? 'VALIDE' : 'NON VALIDE' }}
                                                </button>
											@else
												<td><a href="{{ route('activites.valide', $activite->id) }}" 
													class="btn btn-sm {{ $activite->valide ? 'btn-success' : 'btn-secondary' }}">
													{{ $activite->valide ? 'VALIDE' : 'NON VALIDE' }}
												</a></td>
											@endif
										</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <hr>

                        {{-- Groupe d'activité et Action associée --}}
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Informations liées</u></b></h5>
                                <ul class="list-group list-group-unbordered mb-3">
                                    <li class="list-group-item">
                                        <b>Groupe d'activité :</b> 
                                        <span class="float-right">{{ $activite->groupeactivite->nom ?? '-' }}</span>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Action :</b> 
                                        <span class="float-right">{{ $activite->action->nom ?? '-' }}</span>
                                    </li>
                                    <li class="list-group-item">
                                        <b>Structure responsable :</b> 
                                        <span class="float-right">{{ $activite->structureresponsable->nom ?? '-' }}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <hr>
						

                        {{-- Étapes de l'activité --}}
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Étapes</u></b></h5>
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>Ordre</th>
                                            <th>Nom</th>
                                            <th>Pondération </th>
                                            <th>Niveau exécution</th>
                                            <th>Source de vérification</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($activite->etapes as $etape)
                                            <tr>
                                                <td>{{ $etape->ordre }}</td>
                                                <td>{{ $etape->nom }}</td>
                                                <td>{{ $etape->ponderation }} %</td>
                                                <td>{{ $etape->niveauexec }} %</td>
                                                <td>{{ $etape->sourceverif ?? '-' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <hr>

                        {{-- Structures partenaires --}}
                        <div class="row">
                            <div class="callout callout-primary">
                                <h5><b><u>Structures partenaires</u></b></h5>
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>Structure</th>
                                            <th>Ministère</th>
                                            <th>Début</th>
                                            <th>Fin</th>
                                        </tr>
                                    </thead>
                                    <tbody>
										@php
											$canAddStructure = ($activite->ouvert && $activite->actif) || !$activite->valide;
										@endphp
										@if($canAddStructure)
											<h6 class="card-title">
												<a href="{{ route('structures.selecforactivite', ['activiteid' => $activite->id, 'activitestate' => $canAddStructure]) }}" 
												   class="btn btn-primary rounded-pill">
													<i class="bi bi-plus-circle"></i> Ajouter une structure
												</a>
											</h6>
										@endif
										@if (!is_null($activite->structurespartenaires))
											@foreach($activite->structurespartenaires as $structure)
												<tr>
													<td>{{ $structure->nom }} ({{ $structure->code }})</td>
													<td>{{ $structure->ministere->nom ?? '-' }}</td>
													<td>{{ $structure->pivot->datedebut ?? 'En cours' }}</td>
													<td>{{ $structure->pivot->datefin ?? 'En cours' }}</td>
													@if(!$activite->valide)
													<td> <a href="{{ route('structureactivites.detach', $structure->pivot->id) }}" class="btn btn-info">X</a>
													@endif
												</tr>
											@endforeach
										@endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
						
						<hr>
						
						<div class="row">
							<div class="callout callout-primary">
								<table class="table border-0 mb-0">
									<tr>
										<td class="text-center">
											<a href="{{ route('activites.planning', ['id' => $activite->id]) }}" 
											   class="btn rounded-pill"
											   style="background-color: #0d6efd; color: white; border: none;">
												<i class="bi bi-plus-circle"></i> Prévision
											</a>
										</td>
										<td class="text-center">
											<a href="{{ route('activites.evaluate', ['id' => $activite->id]) }}" 
											   class="btn btn-secondary rounded-pill">
												<i class="bi bi-clipboard-check"></i> Évaluation
											</a>
										</td>
									</tr>
								</table>
							</div>
						</div>

						
						<hr>
						
						<div class="callout callout-primary">
								<h5><b><u><b>Historique des anciens intervenants</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Structure</th>
											<th>Ministère</th>
											<th>Du : </th>
											<th>Au : </th>
										</tr>
									</thead>
									<tbody>
										@if (!is_null($activite->structurearchives))
											@foreach ($activite->structurearchives as $structureold)
											<tr>
												<td>{{ $structureold->nom }} ({{ $structureold->code }})</td>
												<td>{{ $structureold->ministere->nom }} ({{ $structureold->ministere->code }})</td>
												<td>{{ $structureold->pivot->datedebut }}</td>
												<td>{{ $structureold->pivot->datefin }}</td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div>
                    </div> <!-- End card-body -->
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
