@extends('layouts.app')

@section('title', 'Evaluations')

@section('content')
<div class="pagetitle">
  <h3>Tableau des évaluations</h3>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Evaluations</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <!-- Table with stripped rows -->
<style>
.badge {
    display: inline-block;
    padding: 3px 8px;
    border-radius: 5px;
    font-weight: bold;
    font-size: 0.9rem;
}

.bg-blue { background-color: #cfe2ff; color: #003366; }
.bg-yellow { background-color: #fff3cd; color: #856404; }
.bg-orange { background-color: #ffe5b4; color: #b35c00; }
.bg-green { background-color: #d4edda; color: #155724; }
.bg-red { background-color: #f8d7da; color: #721c24; }
</style>
          <table class="table datatable">
            <thead>
              <tr>
                <th>Activité</th>
                <th>Prériode</th>
                <th>Prévision</th>
				<th>Réalisation</th>
				<th>Eccart</th>
				<th>Commentaire</th>
				<th>Validée</th>
              </tr>
            </thead>
            <tbody>
              @foreach($evaluations as $eval)
				@php
					// Gestion du cas où un des deux taux est null
					$tauxPrevision = $eval->taux_prevision ?? 0;
					$tauxRealisation = $eval->taux_realisation ?? 0;
					$eccart = $tauxRealisation - $tauxPrevision;			
				@endphp
                <tr>
					<td>
						{{ $eval->activite->nom }}
						<a href="{{ route('activites.planning', $eval->activite_id) }}" class="btn btn-info"><i class="bi bi-eye"></i></a>
					</td>
					<td>{{ $eval->date_reference }}</td>
					<td>{{ $eval->taux_prevision }}%</td>
					<td>{{ $eval->taux_realisation }}%</td>
					<td>
						@if ($eccart >= 0)
							<span style="background-color: #b7eb8f; color: black; padding: 3px 6px; border-radius: 4px;">{{ $eccart }}%</span>
						@else
							<span style="background-color: #f8b5b5; color: black; padding: 3px 6px; border-radius: 4px;">{{ $eccart }}% </span>
						@endif
					</td>
					<td>{{ $eval->commentaire ?? '-' }}</td>
					<td>
						<span class="badge {{ $eval->valide ? 'bg-success' : 'bg-danger' }}">
							{{ $eval->valide ? 'Oui' : 'Non' }}
						</span>
					</td>
                </tr>
              @endforeach
            </tbody>
          </table>
          <!-- End Table -->

        </div>
      </div>

    </div>
  </div>
</section>
@endsection


