@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">Modifier la prévision  </h2>

    {{-- Affichage des messages flash --}}
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Affichage des erreurs de validation --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Formulaire --}}
    <form action="{{ route('previsionactivites.update', $previsionactivite->id) }}" method="POST">
        @csrf {{-- On garde la protection CSRF --}}

        <input type="hidden" name="activite_id" value="{{ $previsionactivite->activite_id }}">

        <div class="mb-3">
            <label for="ordreevaluation" class="form-label">Ordre d'évaluation</label>
            <input type="number" name="ordreevaluation" id="ordreevaluation" class="form-control" step="1" required
                   value="{{ old('ordreevaluation', $previsionactivite->ordreevaluation) }}">
        </div>

        <div class="mb-3">
            <label for="niveaucible" class="form-label">Niveau cible</label>
            <input type="number" name="niveaucible" id="niveaucible" class="form-control" step="0.01" min="0" max="999.99" required
                   value="{{ old('niveaucible', $previsionactivite->niveaucible) }}">
        </div>

        <div class="mb-3">
            <label for="dateevaluation" class="form-label">Date d'évaluation</label>
            <input type="date" name="dateevaluation" id="dateevaluation" class="form-control" required
                   value="{{ old('dateevaluation', $previsionactivite->dateevaluation) }}">
        </div>

        <button type="submit" class="btn btn-primary">Mettre à jour</button>
        <a href="{{ route('activites.planning', $previsionactivite->activite_id) }}" class="btn btn-secondary">Annuler</a>
    </form>
</div>
@endsection
