@extends('layouts.app')

@section('title', 'Programmes')

@section('content')
<div class="pagetitle">
      <h1>Programmes</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Programmes</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
 <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
            @php
    $usergroupId = Auth::user()->usergroup_id;
@endphp

@if($usergroupId != 3 && $usergroupId != 4)
                 <h5 class="card-title"><a href="{{ route('programmes.create') }}" class="btn btn-primary rounded-pill">
    <i class="bi bi-plus-circle"></i> Ajouter
</a>
</h5>
@endif

  

              <!-- Table with stripped rows -->
             <table class="table datatable">
  <thead>
    <tr>
      
      <th>Nom</th>
      <th>Description</th>
      <th>Actif</th>
      <th>Ouvert</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    @foreach($programmes as $programme)
      <tr>
       
        <td>{{ $programme->code }} : {{ $programme->nom }}</td>
        <td> {{ Str::limit($programme->description, 30) }}</td>
       <td>
    @if(Auth::user()->usergroup_id == 4)
        <button class="btn btn-sm {{ $programme->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
            {{ $programme->actif ? 'Oui' : 'Non' }}
        </button>
    @else
        <a href="{{ route('programmes.fonctactif', $programme->id) }}" 
           class="btn btn-sm {{ $programme->actif ? 'btn-success' : 'btn-secondary' }}">
            {{ $programme->actif ? 'Oui' : 'Non' }}
        </a>
    @endif
</td>

<td>
    @if(Auth::user()->usergroup_id == 4)
        <button class="btn btn-sm {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
            {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
        </button>
    @else
        <a href="{{ route('programmes.fonctouvert', $programme->id) }}" 
           class="btn btn-sm {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}">
            {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
        </a>
    @endif
</td>
        <td>
 <a href="{{ route('programmes.show', $programme->id) }}" class="btn btn-info"><i class="bi bi-eye"></i></a>
          <a href="{{ route('programmes.edit', $programme->id) }}" class="btn btn-warning">
            <i class="bi bi-pen"></i>
          </a>
     @if($usergroupId != 3 && $usergroupId != 4)     
<a href="{{ route('programmes.destroy', $programme->id) }}"
   class="btn btn-danger"
   onclick="return confirm('Supprimer ce programme ?')">
   <i class="bi bi-trash"></i>
</a>
@endif


        </td>
      </tr>
    @endforeach
  </tbody>
</table>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>
@endsection
