@extends('layouts.app')
@section('title', 'Programme')

@section('content')
 <div class="pagetitle">
    <h1>Détails Programme</h1>
    <nav>
		<ol class="breadcrumb">
		    <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
		    <li class="breadcrumb-item"><a href="{{URL::to('programmes')}}">Programmes</a></li>
		    <li class="breadcrumb-item active">Détails</li>
		</ol>
    </nav>
</div><!-- End Page Title -->
<section class="section">
	<div class="row">
		<div class="col-lg-12">
			<div class="card">
				<div class="card-body">
					<h5 class="card-title">Détails du programme: <span id="details"></h5>
					@if(Session::has('status'))
					<div class="col-md-3" style="margin-left:15%">
						<div class="card card-success shadow-sm">
							<div class="card-header">
							    <h3 class="card-title">Correct</h3>

							    <div class="card-tools">
									<button type="button" class="btn btn-tool" data-card-widget="remove">
									    <i class="fas fa-times"></i>
									</button>
							    </div>
							</div>
							<div class="card-body">
								{{Session::get('status')}}
							</div>
						</div>
					</div>
					@endif
					<div class="card-body">
						<h2>Détails : <strong> {{ $programme->nom }}</strong> </h2>
						<hr>
						<div class="row">
							<a href="{{--URL::to('pdf/'.$alertmsg->id)--}}" class="nav-link">
							<!--<button type="button" class="btn btn-block btn-success btn-sm"><i class="nav-icon fas fa-print"></i>Imprimer</button> -->
							</a>
						</div>
						<div class="row">
							<div class="col-md-10">
								<div class="callout callout-primary">
									<h5><b><u>Informations générales</u></b></h5>
									<ul class="list-group list-group-unbordered mb-3">
										<li class="list-group-item">
											<b>Code  : </b> <a class="float-right">  {{$programme->code}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Intitulé  : </b> <a class="float-right">  {{$programme->nom}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Détails  : </b><br> <a class="float-right">  {{$programme->description}}</a><br>
										</li>
										<li class="list-group-item">
											<b>Programme activé : </b> <a class="float-right">
											@if(Auth::user()->usergroup_id == 4)
												<button class="btn btn-sm {{ $programme->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
													{{ $programme->actif ? 'OUI' : 'NON' }}
												</button>
											@else
												 <a href="{{ route('programmes.fonctactif', $programme->id) }}" 
													class="btn btn-sm {{ $programme->actif ? 'btn-success' : 'btn-secondary' }}">
													{{ $programme->actif ? 'OUI' : 'NON' }}
												</a>
											@endif
											</a><br>
										</li>
										<li class="list-group-item">
											<b> Ouvert (en élaboration/revu) : </b> <a class="float-right">
											@if(Auth::user()->usergroup_id == 4)
												<button class="btn btn-sm {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
													{{ $programme->ouvert ? 'OUI' : 'NON' }}
												</button>
											@else
												 <a href="{{ route('programmes.fonctouvert', $programme->id) }}" 
													class="btn btn-sm {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}">
													{{ $programme->ouvert ? 'OUI' : 'NON' }}
												</a>
											@endif
											</a><br>
										</li>
										<li class="list-group-item">
											<b>Responsable programme : </b> <a class="float-right">  
											@isset ($programme->user->id)
												{{$programme->user->name}} ({{$programme->user->email}})</a> 
												<a href="{{ route('programmes.rpremove', $programme->id)}}"> <i class="bi bi-danger" onclick="return confirm('Enlever ce RP?')">X</i> </a>
												<br>
											@else
												{{"Non désigné"}}
											@endisset
											<a href="{{ route('users.rpcreate', ['level' => 'program', 'id' => $programme->id]) }}" class="btn btn-warning">
												<i class="bi bi-plus-circle"></i>Choisir/Modifier le RP
											</a>
											
										</li>
									</ul>
								</div>
							</div>
						</div><hr><hr>
						<div class="row">
							<div class="callout callout-primary">
								<h5><b><u>Liste des actions</u></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Code</th>
											<th>Libellé</th>
											<th>Actif</th>
											<th>Ouvert</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										@if($programme->ouvert && $programme->actif)
											<h6 class="card-title"><a href="{{ route('actions.create', ['progid' => $programme->id]) }}" class="btn btn-primary rounded-pill">
											<i class="bi bi-plus-circle"></i> Ajouter une action</a></h6>
										@endif
										@if (!is_null($programme->actions))
											@foreach ($programme->actions as $action)
											<tr>
												<td>{{ $action->code }} </td>
												<td>{{ $action->nom  }}</td>
												<td><a href="{{ route('actions.actif', $action->id) }}" 
													class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}">
													{{ $action->actif ? 'Oui' : 'Non' }}
												</a></td>
												<td><a href="{{ route('actions.ouvert', $action->id) }}" 
													class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}">
													{{ $action->ouvert ? 'Ouvert' : 'Fermé' }}
												</a></td>
												<td>
													<a href="{{ route('actions.show', $action->id) }}" class="btn btn-info"><i class="bi bi-eye"></i></a>
													<a href="{{ route('actions.edit', $action->id) }}" class="btn btn-warning"><i class="bi bi-pen"></i></a>
													<a href="{{ route('actions.destroy', $action->id) }}" class="btn btn-danger" onclick="return confirm('Supprimer cette action ?')"><i class="bi bi-trash"></i></a>
												</td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div><hr>
                                                <div class="row">
							<div class="callout callout-primary">
								<h5><b><u><b>Historique des RPs</u></b></b></h5>
								<table class="table datatable">
									<thead>
										<tr>
											<th>Responsable</th>
											<th>Du : </th>
											<th>Au : </th>
										</tr>
									</thead>
									<tbody>
										@if (!is_null($programme->responsables))
											@foreach ($programme->responsables as $responsable)
											<tr>
												<td>{{ $responsable->user }} </td>
												<td>{{ $responsable->datedebut }}</td>
												<td>{{ $responsable->datefin?? 'En cours' }}</td>
											@endforeach
										@endif
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
@endsection


