@extends('layouts.app')
@section('title', 'Utilisateurs')

@section('content')
<div class="pagetitle">
  <h1>Liste des Utilisateurs</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Utilisateurs</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">Tous les utilisateurs</h5>
      <a href="{{ route('users.create') }}" class="btn btn-primary mb-3">
        <i class="bi bi-plus-circle"></i> Nouvel utilisateur
      </a>

       <table class="table datatable">
        <thead>
          <tr>
            <th>Nom</th>
            <th>Email</th>
            <th>Groupe</th>
            <th>Actif</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($users as $user)
          <tr>
            <td>{{ $user->name }}</td>
            <td>{{ $user->email }}</td>
            <td>{{ $user->usergroup ? $user->usergroup->nom : 'N/A' }}</td>
            <td>
			<a href="{{ route('users.actif', $user->id) }}" 
               class="btn btn-sm {{ $user->is_active ? 'btn-success' : 'btn-secondary' }}">
              {{ $user->is_active ? 'Oui' : 'Non' }}
            </a>
            </td>
            <td>
              
              <a href="{{ route('users.edit', $user->id) }}" class="btn btn-warning btn-sm">
                <i class="bi bi-pen"></i>
              </a>
			  
<a href="{{ route('users.destroy', $user->id) }}"
   class="btn btn-danger"
   onclick="return confirm('Supprimer cet utilisateur ?')">
   <i class="bi bi-trash"></i>
</a>
              
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>

    </div>
  </div>
</section>
@endsection
