<?php $__env->startSection('title', 'Programmes'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
      <h1>Programmes</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Programmes</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
 <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
            <?php
    $usergroupId = Auth::user()->usergroup_id;
?>

<?php if($usergroupId != 3 && $usergroupId != 4): ?>
                 <h5 class="card-title"><a href="<?php echo e(route('programmes.create')); ?>" class="btn btn-primary rounded-pill">
    <i class="bi bi-plus-circle"></i> Ajouter
</a>
</h5>
<?php endif; ?>

  

              <!-- Table with stripped rows -->
             <table class="table datatable">
  <thead>
    <tr>
      
      <th>Nom</th>
      <th>Description</th>
      <th>Actif</th>
      <th>Ouvert</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php $__currentLoopData = $programmes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $programme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
       
        <td><?php echo e($programme->code); ?> : <?php echo e($programme->nom); ?></td>
        <td> <?php echo e(Str::limit($programme->description, 30)); ?></td>
       <td>
    <?php if(Auth::user()->usergroup_id == 4): ?>
        <button class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
            <?php echo e($programme->actif ? 'Oui' : 'Non'); ?>

        </button>
    <?php else: ?>
        <a href="<?php echo e(route('programmes.fonctactif', $programme->id)); ?>" 
           class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>">
            <?php echo e($programme->actif ? 'Oui' : 'Non'); ?>

        </a>
    <?php endif; ?>
</td>

<td>
    <?php if(Auth::user()->usergroup_id == 4): ?>
        <button class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
            <?php echo e($programme->ouvert ? 'Ouvert' : 'Fermé'); ?>

        </button>
    <?php else: ?>
        <a href="<?php echo e(route('programmes.fonctouvert', $programme->id)); ?>" 
           class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
            <?php echo e($programme->ouvert ? 'Ouvert' : 'Fermé'); ?>

        </a>
    <?php endif; ?>
</td>
        <td>
 <a href="<?php echo e(route('programmes.show', $programme->id)); ?>" class="btn btn-info"><i class="bi bi-eye"></i></a>
          <a href="<?php echo e(route('programmes.edit', $programme->id)); ?>" class="btn btn-warning">
            <i class="bi bi-pen"></i>
          </a>
     <?php if($usergroupId != 3 && $usergroupId != 4): ?>     
<a href="<?php echo e(route('programmes.destroy', $programme->id)); ?>"
   class="btn btn-danger"
   onclick="return confirm('Supprimer ce programme ?')">
   <i class="bi bi-trash"></i>
</a>
<?php endif; ?>


        </td>
      </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </tbody>
</table>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/programmes/index.blade.php ENDPATH**/ ?>