<?php $__env->startSection('title', 'Prévisions'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h3>Tableau des prévisions</h3>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Prévisions</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <!-- Table with stripped rows -->
<style>
.badge {
    display: inline-block;
    padding: 3px 8px;
    border-radius: 5px;
    font-weight: bold;
    font-size: 0.9rem;
}

.bg-blue { background-color: #cfe2ff; color: #003366; }
.bg-yellow { background-color: #fff3cd; color: #856404; }
.bg-orange { background-color: #ffe5b4; color: #b35c00; }
.bg-green { background-color: #d4edda; color: #155724; }
.bg-red { background-color: #f8d7da; color: #721c24; }
</style>
          <table class="table datatable">
            <thead>
              <tr>
                <th>Activité</th>
                <th>Date prévisionnelle</th>
                <th>Taux prévisionnel (%)</th>
		<th>Etat d'évaluation</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $previsions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php

        $today = now();
        $dateEval = \Carbon\Carbon::parse($p->dateevaluation);
        $etat = '';
        $style = '';
        $details = '';

        // Cas 1 : La date d’évaluation n’est pas encore arrivée
        if ($dateEval->isFuture()) {
            $etat = 'À venir';
            $style = 'bg-blue';
        } 
        // Cas 2 : La date est passée
        else{
            if ($p->evaluations->isEmpty()) {
                // ➜ Nombre entier de jours de retard
		$jours = $dateEval->diffInDays($today, false); 
		$jours = (int) $jours;
                $etat = 'En retard';
                $details = "($jours jrs)";
                $style = 'bg-red';
            } else {
                $evaluation = $p->evaluations->first();
                if (!$evaluation->valide) {
                    $etat = 'Évalué non validé';
                    $style = 'bg-orange';
                } else {
                    $etat = 'Évalué et validé';
                    $style = 'bg-green';
                }
            }
        }
    ?>
                <tr>
					<td>
						<?php echo e($p->activite->nom); ?>

						<a href="<?php echo e(route('activites.planning', $p->activite_id)); ?>" class="btn btn-info"><i class="bi bi-eye"></i></a>
					</td>
					<td><?php echo e($p->dateevaluation); ?></td>
					<td><?php echo e($p->niveaucible); ?></td>
					<td>
<span class="badge <?php echo e($style); ?>">
                    <?php echo e($etat); ?> <?php echo e($details); ?>

                </span>
        </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
          <!-- End Table -->

        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/previsionactivites/index.blade.php ENDPATH**/ ?>