<?php $__env->startSection('title', 'Modèle Activité'); ?>

<?php $__env->startSection('content'); ?>
 <div class="pagetitle">
      <h1>Ajout d'une étape</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
          <li class="breadcrumb-item">Modèle Activité</li>
          <li class="breadcrumb-item active">Ajout</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <section class="section">
      <div class="row">
        <div class="col-lg-12">
 <div class="card">
  <div class="card-body">
    <h5 class="card-title">Ajouter une étape</h5>

    <form method="POST" action="<?php echo e(route('etapes.store')); ?>">
      <?php echo csrf_field(); ?>
	  <input type="hidden" name="modeleactivite_id" value="<?php echo e($modelactiviteid); ?>">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Ordre</label>
		  <input type="number" name="ordre" class="form-control" value="<?php echo e(old('ordre', $dernierOrdre)); ?>" required step="1" readonly>
        </div>
        <div class="col-md-6">
          <label class="form-label">Désignation</label>
          <input type="text" name="nom" class="form-control" value="<?php echo e(old('nom')); ?>" required>
        </div>
		<div class="mb-3">
			<label class="form-label"><b>Pondération</b></label>
			<input type="number" id="ponderation" name="ponderation" class="form-control" value="<?php echo e(old('ponderation'), 0.01); ?>" step="0.01" min="0.01" pattern="\d*" onkeypress="return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46">
		</div>
		<div class="mb-3">
			<label class="form-label"><b>Niveau d'exécution</b></label>
			<input type="number" id="niveauexec" name="niveauexec" class="form-control" value="<?php echo e($sommeExistante ?? 0); ?>" readonly step="0.01">
		</div>
        <div class="col-12">
          <label class="form-label">Source de vérification</label>
          <textarea name="sourceverif" class="form-control"><?php echo e(old('sourceverif')); ?></textarea>
        </div>
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
		$(document).ready(function() {
			let sommeExistante = <?php echo e($sommeExistante ?? 0); ?>;
			// Initialise le niveau d'exécution avec la valeur par défaut
			$('#niveauexec').val((sommeExistante + parseFloat($('#ponderation').val())).toFixed(2));

			$('#ponderation').on('blur', function() {
				let nouvellePonderation = parseFloat($(this).val()) || 0;

				// Vérifie que la pondération est strictement positive
				if(nouvellePonderation <= 0) {
					alert('La pondération doit être strictement supérieure à 0 !');
					$(this).val('0.01');
					nouvellePonderation = 0.01;
				}

				let niveau = sommeExistante + nouvellePonderation;

				// Limite la somme à 100
				if (niveau > 100) {
					niveau = 100;
					$(this).val((100 - sommeExistante).toFixed(2));
					alert('La somme des pondérations ne peut pas dépasser 100 !');
				}

				$('#niveauexec').val(niveau.toFixed(2));
			});
		});
		</script>
      </div>

      <div class="mt-3">
        <button type="submit" class="btn btn-success">Enregistrer</button>
  <button type="reset" class="btn btn-secondary">Réinitialiser</button>
      </div>
    </form>
  </div>
</div>

        </div>
      </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\phaso\resources\views/etapes/create.blade.php ENDPATH**/ ?>