<?php $__env->startSection('title', 'Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Ajout d'une Activité</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Accueil</a></li>
      <li class="breadcrumb-item">Activités</li>
      <li class="breadcrumb-item active">Ajout</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Ajouter une activité</h5>

          <form method="POST" action="<?php echo e(route('activites.store')); ?>">
            <?php echo csrf_field(); ?>
			<div class="row g-3">
				<div class="col-md-6">
					<label class="form-label"><b>Groupe d'activité</b></label>
					<select id="groupeSelect" class="form-control">
						<option value="">-- Aucun choix --</option>
						<?php $__currentLoopData = $groupes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($g->id); ?>"><?php echo e($g->nom); ?></option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</select>
				</div>
			</div>

			<div class="row g-3 mt-3">
				<div class="col-md-6">
					<label class="form-label"><b>Nature d'activité</b></label>
					<select name="modele_id" id="modeleSelect" class="form-control">
						<option value="">-- Aucun choix --</option>
					</select>
				</div>
			</div>

			<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
			<script>
				$(document).ready(function() {
					$('#groupeSelect').on('change', function() {
						var groupeId = $(this).val();
						var modeleSelect = $('#modeleSelect');

						modeleSelect.empty().append('<option value="">-- Chargement... --</option>');

						if (groupeId) {
							$.ajax({
								url: '<?php echo e(route("modelespargroupe", ":id")); ?>'.replace(':id', groupeId) + '?t=' + new Date().getTime(),
								type: 'GET',
								cache: false,
								success: function(data) {
									modeleSelect.empty();
									if (data.length > 0) {
										modeleSelect.append('<option value="">-- Aucun choix --</option>');
										$.each(data, function(index, modele) {
											modeleSelect.append('<option value="'+ modele.id +'">'+ modele.nom +'</option>');
										});
									} else {
										modeleSelect.append('<option value="">-- Aucun modèle disponible --</option>');
									}
								},
								error: function(xhr, status, error) {
									console.log(xhr.responseText);
									modeleSelect.html('<option value="">-- Aucun  résultat --</option>');
								}
							});
						} else {
							modeleSelect.html('<option value="">-- Aucun choix --</option>');
						}
					});
				});
				</script>
			<div class="row g-3">
              <div class="col-md-3">
                <label class="form-label"><b>Code</b></label>
                <input type="text" name="code" class="form-control" value="<?php echo e(old('code')); ?>" required>
              </div>

              <div class="col-md-9">
                <label class="form-label"><b>Nom</b></label>
                <input type="text" name="nom" class="form-control" value="<?php echo e(old('nom')); ?>" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date début</b></label>
                <input type="date" name="datedebut" class="form-control" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Date fin</b></label>
                <input type="date" name="datefin" class="form-control" required>
              </div>

              <div class="col-md-4">
                <label class="form-label"><b>Montant</b></label>
                <input type="number" step="0.001" name="montant" class="form-control" required>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Structure responsable</b></label>
                <select name="structure_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($s->id); ?>"><?php echo e($s->nom); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label"><b>Action</b></label>
                <select name="action_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($a->id); ?>" <?php echo e($actionid == $a->id ? 'selected' : ''); ?>>
					<?php echo e($a->nom); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="text-center mt-4">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
                <button type="reset" class="btn btn-secondary">Réinitialiser</button>
              </div>

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\phaso\resources\views/activites/create.blade.php ENDPATH**/ ?>