<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\EvaluationStructure;
use App\Models\Structure;
use App\Models\Programme;
 use App\Models\Activite;
use App\Models\Action;
use Carbon\Carbon;
class DashboardController extends Controller
{
    //
public function index()
    {
         $structuresEnRetard = EvaluationStructure::with('structure')
            ->whereDate('updated_at', '<', Carbon::now()->subYear())
            ->get(['structure_id', 'anneeref', 'updated_at']);
	$nombreStructuresEnRetard = $structuresEnRetard->unique('structure_id')->count();		
			

        $topStructures = EvaluationStructure::with('structure')
            ->orderByDesc('teaj')
            ->limit(10)
            ->get(['structure_id', 'teaj']);

        $lowStructures = EvaluationStructure::with('structure')
            ->orderBy('teaj')
            ->limit(10)
            ->get(['structure_id', 'teaj']);

     
        $tauxParProgramme = Programme::with(['actions.activites'])
            ->get()
            ->map(function ($programme) {
                $tauxMoyen = $programme->actions->flatMap->activites
                    ->avg(fn($a) => (int) $a->prog_actif * 100);

                return [
                    'nom' => $programme->nom,
                    'taux_moyen' => round($tauxMoyen, 2),
                ];
            })
            ->sortByDesc('taux_moyen')
            ->take(5)
            ->values();

        return view('welcome', compact(
            'structuresEnRetard',
'nombreStructuresEnRetard',
            'topStructures',
            'lowStructures',
            'tauxParProgramme'
        ));
    }
}
