<?php

namespace App\Http\Controllers;

use App\Models\Partenaire;
use App\Models\TypePartenaire;
use Illuminate\Http\Request;

class PartenairesController extends Controller
{
    public function index()
    {
         /*$partenaires = Partenaire::with(['typepartenaire'])->get();

        return view('partenaires.index', compact('partenaires'));*/
         try {
            $partenaires = Partenaire::with(['typepartenaire'])->get();
            return view('partenaires.index', compact('partenaires'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des partenaires : ' . $e->getMessage());
        }
    }

    public function create()
    {
       /* $types = TypePartenaire::all();
        return view('partenaires.create', compact('types'));*/
         try {
            $types = TypePartenaire::all();
            return view('partenaires.create', compact('types'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:partenaires,code',
            'nom' => 'required|string|max:100',
            'desctiption' => 'nullable|string',
            'typepartenaire_id' => 'required|exists:typepartenaires,id',
        ]);

       /* Partenaire::create($validated);

        return redirect()->route('partenaires.index')->with('success', 'Partenaire ajouté avec succès.');*/
        
        try {
          

            $partenaire = new Partenaire($validated);

            if ($partenaire->save()) {
                return redirect()->route('partenaires.index')->with('success', 'Partenaire ajouté avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’enregistrement du partenaire.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

 public function edit($id = 0)
    {
       /* $types = TypePartenaire::all();
 $partenaire = Partenaire::findOrFail($id);

        return view('partenaires.edit', compact('partenaire', 'types'));*/
        try {
            $types = TypePartenaire::all();
            $partenaire = Partenaire::findOrFail($id);
            return view('partenaires.edit', compact('partenaire', 'types'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire d’édition : ' . $e->getMessage());
        }
    }

  public function update(Request $request, $id =0)
    {
	$partenaire = Partenaire::findOrFail($id);
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:partenaires,code,' . $partenaire->id,
            'nom' => 'required|string|max:100',
            'desctiption' => 'nullable|string',
            'typepartenaire_id' => 'required|exists:typepartenaires,id',
        ]);

  /*      $partenaire->update($validated);

        return redirect()->route('partenaires.index')->with('success', 'Partenaire mis à jour avec succès.');*/
        try {
           

            if ($partenaire->update($validated)) {
                return redirect()->route('partenaires.index')->with('success', 'Partenaire mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour du partenaire.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
     public function destroy($id)
    {
 /*$partenaire =Partenaire::findOrFail($id);

        $partenaire->delete();
        return redirect()->route('partenaires.index')->with('success', 'Partenaire supprimé avec succès.');*/
    }
}
