@extends('layouts.app')
@section('title', 'Activités')

@section('content')
<div class="pagetitle">
  <h1>Liste des Activités</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Activités</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">Toutes les activités</h5>

      @php
        $usergroupId = Auth::user()->usergroup_id;
      @endphp
      @if(!in_array($usergroupId , [3, 4, 5, 6]))
        <a href="{{ route('activites.create') }}" class="btn btn-primary mb-3">Ajouter une activité</a>
      @endif

      <style>
        /* Tableau stylisé avec bordures et lignes alternées */
        .table-custom {
          width: 100%;
          border-collapse: collapse;
          border: 1px solid #dee2e6;
        }

        .table-custom th,
        .table-custom td {
          border: 1px solid #dee2e6;
          padding: 0.5rem 0.75rem;
          vertical-align: middle;
        }

        /* En-tête sombre et texte blanc */
        .table-custom thead th {
          background-color: #343a40 !important;
          color: #fff !important;
          text-transform: uppercase;
          letter-spacing: 0.5px;
          text-align: center;
        }

        /* Lignes alternées et survol */
        .table-custom tbody tr:nth-child(odd) {
          background-color: #f8f9fa;
        }
        .table-custom tbody tr:hover {
          background-color: #e9ecef;
        }

        /* Centrer certaines colonnes */
        .table-custom td:nth-child(6),
        .table-custom td:nth-child(7),
        .table-custom td:nth-child(8) {
          text-align: center;
        }

        /* Boutons stylisés pour statuts et actions */
        .btn-sm-status {
          padding: 0.25rem 0.5rem;
          font-size: 0.85rem;
          font-weight: bold;
          border-radius: 0.25rem;
          color: #fff;
          text-align: center;
        }

        .btn-sm-status-success { background-color: #28a745; }
        .btn-sm-status-secondary { background-color: #6c757d; }
        .btn-sm-status-warning { background-color: #ffc107; color: #212529; }
        .btn-sm-status-info { background-color: #17a2b8; }
        .btn-sm-status-danger { background-color: #dc3545; }
      </style>

      <table class="table-custom">
        <thead>
          <tr>
            <th style="min-width: 250px;">Code & Nom</th>
            <th>Groupe</th>
            <th>Action</th>
            <th>Responsable</th>
            <th>Montant</th>
            <th>Actif</th>
            <th>Ouvert</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($activites as $a)
          <tr>
            <td>{{ $a->code }} : {{ $a->nom }}</td>
            <td>{{ $a->groupeactivite->nom ?? '-' }}</td>
            <td>{{ $a->action->nom ?? '-' }}</td>
            <td>{{ $a->structureresponsable->nom ?? '-' }}</td>
            <td style="white-space: nowrap;">{{ $a->montant ? number_format($a->montant, 0, '', ' ') : '-' }}</td>

            {{-- Actif --}}
            <td>
              @if(in_array($usergroupId, [3,4,6]))
                <button class="btn-sm-status {{ $a->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                  {{ $a->actif ? 'Oui' : 'Non' }}
                </button>
              @endif
              @if(in_array($usergroupId, [1,2,5]))
                <a href="{{ route('activites.actif', $a->id) }}" 
                   class="btn-sm-status {{ $a->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                  {{ $a->actif ? 'Oui' : 'Non' }}
                </a>
              @endif
            </td>

            {{-- Ouvert --}}
            <td>
              @if(in_array($usergroupId, [3,4,5,6]))
                <button class="btn-sm-status {{ $a->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                  {{ $a->ouvert ? 'Ouvert' : 'Fermé' }}
                </button>
              @endif
              @if(in_array($usergroupId, [1,2]))
                <a href="{{ route('activites.ouvert', $a->id) }}" 
                   class="btn-sm-status {{ $a->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                  {{ $a->ouvert ? 'Ouvert' : 'Fermé' }}
                </a>
              @endif
            </td>

            {{-- Actions --}}
            <td>
              <a href="{{ route('activites.show', $a->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
              @if(!in_array($usergroupId, [3,4,5,6]))
                @if(!$a->valide)
                  <a href="{{ route('activites.edit', $a->id) }}" class="btn-sm-status btn-sm-status-warning"><i class="bi bi-pen"></i></a>
                  @if(in_array($usergroupId, [1,2]))
                    <a href="{{ route('activites.destroy', $a->id) }}" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer cette activité ?')"><i class="bi bi-trash"></i></a>
                  @endif
                @endif
              @endif
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>

    </div>
  </div>
</section>
@endsection
