@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
    <h1>CSDs</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">CSDs</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="{{ route('csds.create') }}" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                    <style>
                        /* Tableau stylisé */
                        .table-custom {
                            width: 100%;
                            border-collapse: collapse;
                            border: 1px solid #dee2e6;
                        }
                        .table-custom th,
                        .table-custom td {
                            border: 1px solid #dee2e6;
                            padding: 0.5rem 0.75rem;
                            vertical-align: middle;
                        }

                        /* En-tête sombre */
                        .table-custom thead th {
                            background-color: #343a40 !important;
                            color: #fff !important;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                            text-align: center;
                        }

                        /* Lignes alternées et survol */
                        .table-custom tbody tr:nth-child(odd) {
                            background-color: #f8f9fa;
                        }
                        .table-custom tbody tr:hover {
                            background-color: #e9ecef;
                        }

                        /* Boutons stylisés */
                        .btn-sm-status {
                            padding: 0.25rem 0.5rem;
                            font-size: 0.85rem;
                            font-weight: bold;
                            border-radius: 0.25rem;
                            color: #fff;
                            text-align: center;
                        }
                        .btn-sm-status-info { background-color: #17a2b8; }
                        .btn-sm-status-danger { background-color: #dc3545; }
                    </style>

                    <table class="table-custom">
                        <thead>
                            <tr>
                                <th style="min-width: 100px;">Code</th>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Editer</th>
                                <th>Supprimer</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($csds as $csd)
                                <tr>
                                    <td>{{ $csd->code }}</td>
                                    <td>{{ $csd->nom }}</td>
                                    <td>{{ $csd->description }}</td>
                                    <td>
                                        <a href="{{ route('csds.edit', $csd->id) }}" class="btn-sm-status btn-sm-status-info">
                                            <i class="bi bi-pen"></i>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('csds.destroy', $csd->id) }}" 
                                           class="btn-sm-status btn-sm-status-danger"
                                           onclick="return confirm('Supprimer ce CSD ?')">
                                           <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
