@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">Modifier l'évaluation </h2>

    {{-- Affichage des messages flash --}}
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Affichage des erreurs de validation --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Formulaire --}}
    <form action="{{ route('evaluations.update', $evaluation->id) }}" method="POST">
        @csrf {{-- On garde la protection CSRF --}}

        <input type="hidden" name="activite_id" value="{{ $evaluation->activite_id }}">
		<label class="form-label">Activité : {{$evaluation->activite->nom}}</label>
		<input type="hidden" name="previsionactivite_id" value="{{ $evaluation->previsionactivite_id }}">
		<label class="form-label">Prévision : {{$evaluation->prevision->niveaucible}}</label>
		
        <div class="mb-3">
			<input type="hidden" name="taux_prevision" value="{{ $evaluation->taux_prevision }}">
            <label class="form-label">Niveau cible : {{$evaluation->taux_prevision}}</label>

        </div>
		
		<div class="mb-3">
			<label class="form-label"><b>Etape</b></label>
			<select name="etape_id" class="form-control" required>
			  <option value="">-- Choisir --</option>
			  @foreach($etapes as $s)
				<option value="{{ $s->id }}" {{ $s->id == $evaluation->etape_id ? 'selected' : '' }}>
				  {{ $s->nom }} ({{ $s->niveauexec }}%)
				</option>
			  @endforeach
			</select>
        </div>

        <div class="mb-3">
            <label for="date_evaluation" class="form-label">Date d'évaluation</label>
            <input type="date" name="date_evaluation" id="date_evaluation" class="form-control" required
                   value="{{ old('date_evaluation', $evaluation->date_evaluation) }}">
        </div>

        <button type="submit" class="btn btn-primary">Mettre à jour</button>
        <a href="{{ route('evaluations.update', $evaluation->id) }}" class="btn btn-secondary">Annuler</a>
    </form>
</div>
@endsection
