@extends('layouts.app')

@section('title', 'Événements')

@section('content')
<div class="pagetitle">
    <h1>Liste des événements</h1>
</div>

<section class="section">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Toutes les sessions et événements</h5>

            <style>
                .table-custom {
                    width: 100%;
                    border-collapse: collapse;
                    border: 1px solid #dee2e6;
                }
                .table-custom th,
                .table-custom td {
                    border: 1px solid #dee2e6;
                    padding: 0.5rem 0.75rem;
                    vertical-align: middle;
                }
                .table-custom thead th {
                    background-color: #dc3545; /* Rouge */
                    color: #fff;
                    text-align: center;
                    text-transform: uppercase;
                    letter-spacing: 0.5px;
                }
                .table-custom tbody td {
                    text-align: left;
                }
                .table-custom tbody tr:nth-child(odd) {
                    background-color: #f8f9fa;
                }
                .table-custom tbody tr:hover {
                    background-color: #e9ecef;
                }
                .badge-custom {
                    padding: 0.35em 0.65em;
                    font-size: 0.85rem;
                    font-weight: 500;
                    border-radius: 0.25rem;
                }
            </style>

            <table class="table-custom">
                <thead>
                    <tr>
                        <th>Utilisateur</th>
                        <th>Niveau</th>
                        <th>Détails</th>
                        <th>Date</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($evenements as $e)
                    <tr>
                        {{-- Utilisateur --}}
                        <td>
                            @if(Str::startsWith($e->details, 'Échec'))
                                -
                            @else
                                {{ $e->utilisateur->email ?? '-' }}
                            @endif
                        </td>

                        {{-- Niveau --}}
                        <td>
                            @switch($e->level)
                                @case(1)
                                    <span class="badge bg-info badge-custom">Info</span>
                                    @break
                                @case(2)
                                    <span class="badge bg-warning text-dark badge-custom">Avertissement</span>
                                    @break
                                @case(3)
                                    <span class="badge bg-danger badge-custom">Danger</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary badge-custom">Inconnu</span>
                            @endswitch
                        </td>

                        {{-- Détails --}}
                        <td>{{ $e->details }}</td>

                        {{-- Date --}}
                        <td>{{ $e->created_at->format('d/m/Y H:i') }}</td>

                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</section>
@endsection
